<?php
//the functions to handle insertions
function xf_new_post($post_id)
{
	global $XF;
	
	$post = get_post($post_id);
	
	if($post->post_type == 'post')
	{
		//get the category for this post
		$categories = get_the_category($post->ID);

		//lookup what forum ID posts of this category go in
		$forum_id;
		$forum_id_array = $XF->options['xf_category_forum_id'];
		foreach($categories as $category)
		{
			$slug = $category->slug;
			if(isset($forum_id_array[$slug]) && $forum_id_array[$slug] != 0)
			{
				$forum_id = $forum_id_array[$slug];
				break;
			}
		}
		if(!isset($forum_id))
		{
			$forum_id = $forum_id_array['default'];
		}
			
		xf_insert_thread($post, $forum_id);		
	}
	elseif($post->post_type == 'page' && $XF->options['use_thread_creation_page'] == 'on')
	{
		$post = get_post($page_id);
	
		$forum_id = $XF->options['xf_forum_id_page'];
	
		xf_insert_thread($post, $forum_id);
	}
}

function xf_insert_thread($post, $forum_id)
{
	global $XF, $wpdb;
	
	$title = $post->post_title;
	$content = $post->post_content;

	$forumModel = $XF->getModelFromCache('XenForo_Model_Forum');
	$forum = $forumModel->getForumById($forum_id);
	
	if(!$forum)
	{
		wp_die("The Forum ID specified is not valid, check your XenForo bridge options");
	}
	
	if($forumModel->canPostThreadInForum($forum, $errorPhraseKey = ''))
	{
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
		$writer->set('user_id', $XF->visitor->get('user_id'));
		$writer->set('username', $XF->visitor->get('username'));
		if($title != '')
		{
			$writer->set('title', $title);
		}
		else //Just in case the user entered no title for their post
		{
			$writer->set('title', 'New Blog Post');
		}
		$writer->set('node_id', $forum_id);
		
		$writer->set('discussion_state', $XF->getModelFromCache('XenForo_Model_Post')->getPostInsertMessageState(array(), $forum));
		
		//determine the post body that we should be inserting
		$post_contains = $XF->options['first_post_contains'];
		
		$body = '';
		if($post_contains == 'full')
		{
			$body = '[quote]' . XenForo_Html_Renderer_BbCode::renderFromHtml(nl2br($content)) . "[/quote]";
		}
		
		$body .= "[URL='" . get_permalink($wp_post_id) . "']View the Post on the Blog[/URL]";
		
		$postWriter = $writer->getFirstMessageDw();
		$postWriter->set('message', $body);
		$postWriter->setExtraData(XenForo_DataWriter_DiscussionMessage::DATA_ATTACHMENT_HASH, '');
		
		$writer->preSave();
		
		if (!$writer->hasErrors())
		{
			//$this->assertNotFlooding('post'); TODO do this?
			
			$writer->save();
			$thread = $writer->getMergedData();
			$thread_id = $thread['thread_id'];
			
			$wpdb->query("UPDATE $wpdb->posts SET thread_id = '$thread_id' WHERE ID = '{$post->ID}'");
		}
	}
	else
	{
		wp_die("You do not have permission to post in this forum");
	}
}

function xf_edit_post($post_id)
{
	global $XF, $wpdb;
	
	$post = get_post($post_id);
	
	if($post->thread_id != '0') //edit post
	{
		$title = $post->post_title;
		$content = $post->post_content;
		$threadModel = $XF->getModelFromCache('XenForo_Model_Thread');
		$thread = $threadModel->getThreadById($post->thread_id);
		$post_id = $thread['first_post_id'];
		
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
		$writer->setExistingData($thread['thread_id']);
		
		if($title != '')
		{
			$writer->set('title', $title);
		}
		else //Just in case the user entered no title for their post
		{
			$writer->set('title', 'New Blog Post');
		}
		
		if(!$writer->hasErrors())
		{
			$writer->save();
		}
		
		
		//determine the post body that we should be inserting
		$post_contains = $XF->options['first_post_contains'];
		
		$body = '';
		
		if($post_contains == 'full')
		{
			$body = '[quote]' . XenForo_Html_Renderer_BbCode::renderFromHtml(nl2br($content)) . "[/quote]";
		}
		
		$body .= "[URL='" . get_permalink($wp_post_id) . "']View the Post on the Blog[/URL]";
			
		
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
		$writer->setExistingData($post_id);
		$writer->set('message', $body);
		
		$writer->preSave();
		
		if(!$writer->hasErrors())
		{
			$writer->save();
		}
	}
}

global $XF;

//the edit post actions
add_action('publish_post', 'xf_edit_post');

if($XF->options['use_thread_creation_page'] == 'on')
{
	add_action('publish_page', 'xf_edit_post');
}

//the post creation actions
add_action('pending_to_publish', 'xf_new_post');
add_action('draft_to_publish', 'xf_new_post');
add_action('new_to_publish', 'xf_new_post');
add_action('future_to_publish','xf_new_post');
?>