<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * cls_mypdo.php
 * @package plugins_shared
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//------------------------------------------------------------------------------------
/**
 * Extends php's PDO class
 * @return array query results || boolean query completed successfully
 */
class eipPDO extends PDO
{
	private $dsn;							//to hold the connection string to the database
	private $args	= Array('sql'=>null, 'access'=>'READ','SuppressErrors'=>TRUE, 'ReturnID'=>false);	//runtime arguments
	private $stmt;							//sql statement
	private $id;							//id that was created for INSERT statement
	private $arr_Result;					//store the results for a select statement
	private $bol_Success 		= false;	//did the query complete successfully

	public function getResults($args){return($this->ReturnResults($args));}
	public function getID(){return($this->id);}
	public function __construct($userOptions)
	{//overrides pdo construct
		try
		{
			$lp = new eipXFConfig($userOptions['forumDirectory']);
			$this->dsn = "mysql" .":host=".$lp->getValue("db","host") . ";dbname=". $lp->getValue("db","dbname");
			parent::__construct($this->dsn,$lp->getValue("db","username"),$lp->getValue("db","password"));
		}
		catch (PDOException $e)
		{
    		if(!$this->args['SuppressErrors']){echo("Query failed: " . $e->getMessage());}
	    }
	}

	private function ProcessArgs($args)
	{
		try
		{
			if(is_array($args)){$this->args = array_merge($this->args,$args);};		//merge the args into an array
			if($this->args['sql']==null){throw new ExceptionHandler("Database Query not specified");}
			$this->args['access'] =  strtoupper($this->args['access']);				//conver the string to uppercase
		}
	    catch(ExceptionHandler $e)
	    {
	        $e->ParseError('Invalid Arguments');
	    }
	}

	private function RunQuery()
	{
		try
		{
			switch($this->args['access'])
			{
				case "READ":
				{
					$this->stmt = $this->prepare($this->args['sql']);		//preparet the statement
					$this->stmt->setFetchMode(PDO::FETCH_ASSOC);			//set the fetch mode
					$this->stmt->execute();									//run the query
					$this->arr_Result = $this->stmt->fetchAll();			//store the results in the array
					$this->bol_Success = (count($this->arr_Result)>0) ? true : false;	//was it successful
					break;
				}
				case "UPDATE":
				{
					$this->beginTransaction();						//turn autocommit off
					$this->stmt	= $this->exec($this->args['sql']);	//run the qry
					if($this->args['ReturnID']){$this->id = $this->lastInsertId();}	//get the ID before committing transaction
					$this->bol_Success = $this->commit();			//commit the transaction
					if((!$this->bol_Success) && (!$this->args['SuppressErrors'])){throw new PDOException();}
					break;
				}
			}
		}
		catch (PDOException $e)
		{
			if(!$this->args['SuppressErrors']){echo("Query failed: " . $e->getMessage());}
		}
	}

	private function ReturnResults($args)
	{
		try
		{
			$this->ProcessArgs($args);										//process the args
			$this->RunQuery();												//run the query
			switch($this->args['access'])
			{
				case "READ":
				{
					if($this->bol_Success)
					{
						return($this->arr_Result);
					}
					else
					{
						return($this->bol_Success);
					}
					break;
				}
				case "UPDATE":
				{
					return($this->bol_Success);
					break;
				}
				default:
				{
					return(false);
				}
			}
		}
		catch(ExceptionHandler $e)
	    {
	        $e->ParseError('Invalid Results');
	    }
	}

	public function NewQuery($args)
	{
		$this->ProcessArgs($args);												//process the args
		$this->RunQuery();														//run the query
	}

	public function __destruct()
	{
		$this->stmt = null;	$this->arr_Result = null; $this->args = null;
	}
}
?>