<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * qry_lastposts.php:    run the query to get the last posts
 * @package plugins_lastposts
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//------------------------------------------------------------------------------------
/**
 * Get Last Posts --> run the queries to get the latest forum posts
 * @return string last post query 
 */
function qry_LastPost($userOptions)
{
	try
	{
		$qry_sql = 	" 	SELECT 	thread.thread_id,
								thread.title, 
								thread.username					as threadstarter,
								thread.user_id					as threadstarterid,
								thread.reply_count				as replies,
								thread.last_post_id				as lastpostid,
								thread.last_post_username		as lastposter,
								thread.last_post_user_id		as lastposteruserid,
								thread.last_post_date			as lastpostdate,
								usr.avatar_date					as lastposteravatardate,
								TRUNCATE(usr.user_id, -3)/1000	as lastposteravatardir
								
						FROM 	xf_thread					as thread
								inner join xf_user 			as usr
								on thread.user_id = usr.user_id

						WHERE 	thread.discussion_state = 1
								AND usr.message_count >= " . $userOptions['forumUserPosts'] . "
								AND node_id NOT IN  (" . $userOptions['excludeNodes'] . ")
								AND thread.last_post_date >=UNIX_TIMESTAMP(DATE_SUB(NOW(),INTERVAL " . $userOptions['forumLookBack'] . " DAY))
								AND usr.user_group_id NOT IN (" . $userOptions['forumUserGroup'] .")  
						ORDER BY last_post_date DESC
					";		
		$qry_sql .= ($userOptions['forumPosts']>=1 && $userOptions['forumPosts']<=100) ? 
					" LIMIT 0," .  $userOptions['forumPosts']
					:" LIMIT 0,10";
		return($qry_sql);
	}
    catch(ExceptionHandler $e)
    {
        $e->ParseError($qry_sql);
    }
}
?>