<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * cls_sidebarlist.php:   build an html UL for the sidebar section
 * @package plugins_lastposts
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//------------------------------------------------------------------------------------
/*	here is where you can customize the what the table output will look like for your own needs
	use a foreach loop to loop through each row.  The sql results are stored in the array self::$arr_Results
	the query returns the following fields for you to use. 
	thread_id,			-- id of the thread
	title, 				-- thread title
	threadstarter,  	-- username of who started the thread
	replies,			-- number of replies to the thread
	lastpostid,			-- id of the last message posted
	lastposter,			-- username of the last person to reply to the the thread
	last_post_date		-- date of the last reply to the thread
	If you want to bring back more fields the query is located in the /qry/qry_lastposts.php file
*/
/**
 * Build Sidebar Table -->  build the html table for the footer section
 * @return string html formatted
 */
class sidebarList
{
	private static $qryResults = array();
	public static $arr_Needle;		//array to hold values to search for
	private static $arr_NewValue;	//array to hold the replacement values
	private static $lnk_avatar;		//string to hold the link to default avatar 
	public function __construct($qryResults)
	{
		if(is_array($qryResults))
		{
			self::$qryResults = $qryResults;
			self::$arr_Needle 	= array(' ','/','\\','.','?','"','!','\'','(',')');		//values to search for in the title
			self::$arr_NewValue = array('-','-','-' ,'' ,'' ,'' ,'' ,''  ,'' ,'' );		//replacement values
			self::$lnk_avatar = "styles/default/xenforo/avatars/avatar_s.png";
		}
	}
	/**
	 * build the footer table
	 * @param string Forum Domain 
	 * @return string html formatted table
	 */
	public function getHtmlTable()
	{
		$row_counter = 0;
		$class_row = "eipOddRow";
		$html_Title = new Link(array('href'=>getLastPosts::$userOptions['forumDomain'].'/index.php?find-new/threads',
									'text'=>getLastPosts::$userOptions['forumTitle']));
		if(count(self::$qryResults)>=1)
		{	
			$html_Tbl = "<div id='eipWidgetLP' class='eipWidgetLPShell'>";
			$html_Tbl .= "<div class='eipWidgetLPTopRow'>".
			"   ". $html_Title->getElement() ." 
			"."	</div>";
			foreach (self::$qryResults as $feRow)
			{
				$row_counter++;
				($row_counter % 2 == 0) ? $class_row = "eipEvenRow" : $class_row = "eipOddRow";
				$scrubbedTitle = self::scrub_title($feRow['title'], $feRow['thread_id']);
				$html_Lnk 	= New Link(array("href"=>$scrubbedTitle, "target"=>"_blank",  "text"=>substr($feRow['title'],0,getLastPosts::$userOptions["forumThreadLen"])));
				$html_Post	= New Link(array("href"=>$scrubbedTitle."page-".ceil($feRow['replies']/20)."#post-".$feRow['lastpostid'], "text"=>$feRow['replies']));
				$html_Mbr	= New Link(array("href"=>self::formatMbrLink($feRow['lastposter'], $feRow['lastposteruserid']), "target"=>"_blank","text"=>$feRow['lastposter']));
				$html_Avtr	= New Link(array("href"=>self::formatMbrLink($feRow['lastposter'], $feRow['lastposteruserid']),"text"=>self::formatAvtrtLink($feRow)));
				
				//building the divs here
				$html_Tbl .= "<div class='eipLPAvatar " . $class_row . "'>".
						$html_Avtr->getElement() ."
					</div>
					<div class='eipLPListTitle " . $class_row . "'>
					" . $html_Lnk->getElement() . "
					</div>
					<div class='eipLPUserName " . $class_row . "'>".
						$html_Mbr->getElement() ."
					</div>
					<div class='eipLPDate " . $class_row . "'>".
						date('M d H:i',$feRow['lastpostdate']) . "
					</div>";
			}
			$html_Tbl .= "</div>"; //close the shell
			return($html_Tbl);
		}
		else 
		{
			return("empty table");
		}
	}

	private function scrub_title($currentValue, $id)
	{
		return (getLastPosts::$userOptions['forumDomain'] . "index.php?threads/" . 	str_replace(self::$arr_Needle, self::$arr_NewValue, $currentValue). "." . $id ."/" );
	}
	private function formatMbrLink($mbr_name, $mbr_id)
	{
		return(getLastPosts::$userOptions['forumDomain'] . "index.php?members/" . $mbr_name . "." . $mbr_id . "/");
	}
	private function formatAvtrtLink($feRow)
	{
		$lnk_Avtr = ($feRow['lastposteravatardate']>0) ?  getLastPosts::$userOptions['forumDomain'] .'data/avatars/s/' 
				  . intval($feRow['lastposteravatardir'],0) . '/'. $feRow['lastposteruserid'] .'.jpg?' . $feRow['lastposteravatardate'] 
				  : getLastPosts::$userOptions['forumDomain']  . self::$lnk_avatar ;
				
		return('<img src="' . $lnk_Avtr . '" width="48" height="48" alt="' . $feRow['lastposter'].'" />');
	}
}
?>