<?php
//------------------------------------------------------------------------------------
//status:               CHECKED IN
//------------------------------------------------------------------------------------
/**
 * cls_footertable.php:   build the html table for the footer section
 * @package plugins_lastposts
 * @version version 1.4.0
 * @copyright EIP Software LLC - eipSoftware_Copyright.php
 */
//------------------------------------------------------------------------------------
/*	here is where you can customize the what the table output will look like for your own needs
	use a foreach loop to loop through each row.  The sql results are stored in the array self::$arr_Results
	the query returns the following fields for you to use. 
	thread_id,			-- id of the thread
	title, 				-- thread title
	threadstarter,  	-- username of who started the thread
	replies,			-- number of replies to the thread
	lastpostid,			-- id of the last message posted
	lastposter,			-- username of the last person to reply to the the thread
	last_post_date		-- date of the last reply to the thread
	If you want to bring back more fields the query is located in the /qry/qry_lastposts.php file
*/
/**
 * Build Footer Table -->  build the html table for the footer section
 * @return string html formatted
 */
class footerTable
{
	private static $qryResults = array();
	public static $arr_Needle;		//array to hold values to search for
	private static $arr_NewValue;	//array to hold the replacement values
	

	public function __construct($qryResults)
	{
		if(is_array($qryResults))
		{
			self::$qryResults = $qryResults;
			self::$arr_Needle 	= array(' ','/','\\','.','?','"','!','\'','(',')');		//values to search for in the title
			self::$arr_NewValue = array('-','-','-' ,'' ,'' ,'' ,'' ,''  ,'' ,'' );		//replacement values
		}
	}
	/**
	 * build the footer table
	 * @param string Forum Domain 
	 * @return string html formatted table
	 */
	public function getHtmlTable()
	{
		
		if(count(self::$qryResults)>=1)
		{			
			$html_Tbl = new Table(Array("id"=>"tbl1","class"=>"tblforums","columns"=>3,"text"=>""));
			//push the table header cells into the obj
				array_push($html_Tbl->Cells, New Cell(array('header'=>'true','id'=>'HdrCol1',"class"=>"col1","text"=>"Thread / Thread Starter")));		
				array_push($html_Tbl->Cells, New Cell(array('header'=>'true','id'=>'HdrCol2',"class"=>"col2","text"=>"Replies")));
				array_push($html_Tbl->Cells, New Cell(array('header'=>'true','id'=>'HdrCol3',"class"=>"col3","text"=>"Last Post / Member")));
			//cycle through the query results pushine into the Cells collection
			foreach(self::$qryResults as $feRow)
			{
				//$scrubbedTitle = self::$userOptions['forumDomain'] . "index.php?threads/" . str_replace($needle,$newval,$feRow['title']) . "." . $feRow['thread_id']."/";
				$scrubbedTitle = self::scrub_title($feRow['title'], $feRow['thread_id']);
				$html_Lnk	= New Link(array("href"=>$scrubbedTitle, "target"=>"_blank",  "text"=>substr($feRow['title'],0,getLastPosts::$userOptions["forumThreadLen"])));
				$html_Post	= New Link(array("href"=>$scrubbedTitle."page-".ceil($feRow['replies']/20)."#post-".$feRow['lastpostid'], "text"=>$feRow['replies']));
				$html_Usr	= New Link(array("href"=>self::formatMbrLink($feRow['threadstarter'], $feRow['threadstarterid']), "target"=>"_blank","text"=>$feRow['threadstarter']));
				$html_Mbr	= New Link(array("href"=>self::formatMbrLink($feRow['lastposter'], $feRow['lastposteruserid']), "target"=>"_blank","text"=>$feRow['lastposter']));
			//push onto the array, the table cells
				array_push($html_Tbl->Cells, 
								New Cell(array("class"=>"thread",	"text"=>$html_Lnk->getElement())), //$feRow['title'])),
								New Cell(array("class"=>"posts",	"text"=>$html_Post->getElement())), //$feRow['replies'])),
								New Cell(array("class"=>"lastdate",	"text"=>date('M d, Y  H:i',$feRow['lastpostdate']))),
								New Cell(array("class"=>"user",		"text"=>$html_Usr->getElement())),
								New Cell(array("class"=>"blank",	"text"=>"&nbsp;")),
								New Cell(array("class"=>"lastuser",	"text"=>$html_Mbr->getElement()))
						);
			}
			return($html_Tbl->getElement());
		}
		else 
		{
			return("empty table");
		}
	}

	private function scrub_title($currentValue, $id)
	{
		return (getLastPosts::$userOptions['forumDomain'] . "index.php?threads/" . 	str_replace(self::$arr_Needle, self::$arr_NewValue, $currentValue). "." . $id ."/" );
	}
	private function formatMbrLink($mbr_name, $mbr_id)
	{
		return(getLastPosts::$userOptions['forumDomain'] . "index.php?members/" . $mbr_name . "." . $mbr_id . "/");
	}
}
?>