<?php

class WdbPopularContent_Model_PopularContent extends XenForo_Model
{
	/**
	 * Gets the most popular content in descending order
	 *
	 */
	public function getPopularContent($limit,$timeFrame=2,$type='threads')
	{
		if (($timeFrame<1)||($timeFrame>3)) $timeFrame=2;
		if ($timeFrame==1) 	$daysLimit = (int)XenForo_Application::get('options')->wdbPopularContentTimeFrame1;
		if ($timeFrame==2) 	$daysLimit = (int)XenForo_Application::get('options')->wdbPopularContentTimeFrame2;
		if ($timeFrame==3) 	$daysLimit = (int)XenForo_Application::get('options')->wdbPopularContentTimeFrame3;

		$previewLength = (int)XenForo_Application::get('options')->wdbPopularContentPreviewLength;

		$timeNow=time();

		//WdbPopularContent_Installer::uninstall(); //delete cache

		//check cache for good enough data
		$goodCache=false;
		if (XenForo_Application::get('options')->wdbPopularContentEnableCache){
			$cache = XenForo_Model::create('XenForo_Model_DataRegistry')->get("WdbPop_$type$timeFrame");
			if ($cache) {
				$data=unserialize($cache);
				if (isset($data['fromTime'])) {
					$cacheDaysLimit=($timeNow-$data['fromTime'])/(60*60*24);
					if (($daysLimit/$cacheDaysLimit>0.9)&&($daysLimit/$cacheDaysLimit<1.1)){
						if ((isset($data['maxResults']))&&($data['maxResults']==$limit)) {
							if ((isset($data['previewLength']))&&($data['previewLength']==$previewLength)) {
								$goodCache=true;
								//echo "<p>Cache is good, days: $cacheDaysLimit wanted days: $daysLimit fraction: " . $daysLimit/$cacheDaysLimit ."</p>";
							}
						}
					}
				}
			}
		}

		if (!$goodCache){

			// no good cache found so calculate results and fill cache
			$fromTime = $timeNow - ($daysLimit * 60*60*24);
			if ($type=='posts'){
				$query="select *,xf_post.post_date post_post_date from (
				SELECT content_id, COUNT(*) AS c
				FROM xf_liked_content
				WHERE content_type = 'post'
				AND like_date > $fromTime
				GROUP BY content_id order by c desc limit $limit) t1
				join xf_post on t1.content_id = xf_post.post_id
				join xf_thread on xf_post.thread_id=xf_thread.thread_id
				join xf_forum on xf_thread.node_id = xf_forum.node_id
				join xf_user on xf_post.user_id = xf_user.user_id
				order by c desc
				";
				$results = $this->_getDb()->fetchAll($query);
			}else{

				//slower but more accurate
				$query1="select * from
				(select thread_id,count(distinct user_id) c from
				(SELECT thread_id,user_id FROM xf_post where post_date > $fromTime) t
				group by thread_id order by c desc limit $limit) t2
				join xf_thread on t2.thread_id=xf_thread.thread_id
				join xf_post on xf_thread.first_post_id = xf_post.post_id
				join xf_forum on xf_thread.node_id = xf_forum.node_id
				join xf_user on xf_thread.user_id = xf_user.user_id
				order by c desc, reply_count desc;";

				//faster
				$extraLimit=$limit*2;
				$query2="select *,xf_post.post_date post_post_date from
				(select thread_id, count(distinct user_id) c from
				(select t.thread_id,p.user_id from
				(SELECT thread_id FROM xf_thread where post_date>$fromTime order by reply_count desc limit $extraLimit) t join xf_post p on t.thread_id=p.thread_id) t2
				group by thread_id order by c desc limit $limit) t3
				join xf_thread on t3.thread_id=xf_thread.thread_id
				join xf_post on xf_thread.first_post_id = xf_post.post_id
				join xf_forum on xf_thread.node_id = xf_forum.node_id
				join xf_user on xf_thread.user_id = xf_user.user_id
				order by c desc, reply_count desc
				;";

				$results = $this->_getDb()->fetchAll($query2);
			}

			mb_regex_encoding("UTF-8");
			mb_internal_encoding("UTF-8");

			foreach ($results AS $key => $post)
			{
				$message=$post['message'];


				//$message = preg_replace('#\[.*?\]#i','', $message); //strip bbcode
				//$message = preg_replace('#(\S{25})\S+#is','$1...', $message); //trim long strings
				//$message = substr($message, 0,350); // truncate message

				$message = mb_ereg_replace('\[.*?\]','', $message,$option = "i"); //strip bbcode

				//trim long strings
				$mstrings=mb_split("\s",$message);
				foreach ($mstrings AS $mkey => $mstring){
					if (utf8_strlen($mstring)>25){
						$mstrings[$mkey]=utf8_substr($mstring,0,25) . "...";
					}
				}
				$message=implode(" ",$mstrings);

				$message = XenForo_Helper_String::wholeWordTrim($message,$previewLength);  // truncate message

				$results[$key]['message']=$message;
			}

			$data=array('posts'=>$results,'maxResults'=>$limit,'previewLength'=>$previewLength,'fromTime'=>$fromTime,'queryDate'=>$timeNow);

			if (XenForo_Application::get('options')->wdbPopularContentEnableCache){
				// save data to cache
				XenForo_Model::create('XenForo_Model_DataRegistry')->set("WdbPop_$type$timeFrame", serialize($data));
			}
		}

		// check viewing permission
		foreach ($data['posts'] as $key => $post){
			if (!$this->_getPostModel()->canViewPostAndContainer($post, $post, $post)){
				unset($data['posts'][$key]);
			}
			if (($post['message_state']=='deleted')||($post['discussion_state']=='deleted')){
				unset($data['posts'][$key]);
			}
		}

		//Zend_Debug::dump($data);
		return $data;
	}


	/**
	 * @return XenForo_Model_Post
	 */
	protected function _getPostModel()
	{
		return $this->getModelFromCache('XenForo_Model_Post');
	}

}
