<?php
// Last modified: version 1.8


//	DEV TOOLS:
//	$mergedParams = array_merge($template->getParams(), $hookParams);
//	Zend_Debug::dump($mergedParams["nodeList"]["nodesGrouped"][0]);
//	if ($hookName == $hookName) { $contents .= '<span style="diplay:inline;color:red;">' . $hookName . '</span><br />'; }
//	if ($templateName == $templateName) { $content .= '<span style="diplay:inline;color:red;">' . $templateName . '</span><br />'; }
//	in templates: {xen:helper dump, $category.node_id}


class ToggleME_Listener
{
	public static function template_hook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
           $options = XenForo_Application::get('options');

	   if ($options->toggleME_enabled)
           {
           	//Don't use the styleid extrated from "XenForo_Visitor::getInstance". Reason: the styleid of the Unregistered user is "0".
		$style_session = $template->getParam('visitorStyle'); 
                $visitor = XenForo_Visitor::getInstance();
       	        $visitorUserGroupIds = array_merge(array((string)$visitor['user_group_id']), (explode(',', $visitor['secondary_group_ids'])));
                		
		//The isset conditional purpose is to avoid error message during installation and upgrade process
		if(isset($options->toggleME_Usergroups_Forumhome))
		{
			$toggle_forumhome_usr = array_intersect($visitorUserGroupIds, $options->toggleME_Usergroups_Forumhome);
		}
		if(isset($options->toggleME_Usergroups_Postbit))
		{
			$toggle_postbit_usr = array_intersect($visitorUserGroupIds, $options->toggleME_Usergroups_Postbit);
		}
		if(isset($options->toggleME_Usergroups_Widgets))
		{
			$toggle_widgets_usr = array_intersect($visitorUserGroupIds, $options->toggleME_Usergroups_Widgets);
		}		
		if(isset($options->toggleME_styles))
		{
			$toggle_styles = in_array($style_session['style_id'], $options->toggleME_styles);			
		}				

                if ($toggle_styles AND ($toggle_forumhome_usr OR $toggle_postbit_usr))
                {
		        if ($hookName == 'page_container_head')
		        {
				$contents .= $template->create('toggleme_page_container_js', $template->getParams());
		        }

		        if ($hookName == 'forum_list_nodes' AND $options->toggleME_selected_areas['node_categories'] AND $toggle_forumhome_usr)
		        {
			//For categories using by addons or styles


				/*
				Let's create the foundation of the ID... based on the addition of each number of the crc of the full_url
				Why ? I don't know if the hook 'forum_list_nodes' is only displayed in the forumhome page. In the javascript
				file, I'm using 'index' function to count the ID of the category (that doesn't belong to XenForo, ie: Chatbox). 
				Without this part of code, if the first category W of page A is closed, then the first category Y will also be 
				closed on page B.
				*/

				$full_url = $template->getParam('requestPaths');
				$full_url = $full_url['fullBasePath'];
				$CRC_ID = array_sum(str_split(crc32($full_url)));


				//The regex backreference (?<!"></div>) is to avoid redundancy with the similar replacement inside the template_postrender function
				$search[] = '#((?<!"></div>)<div class="categoryText">)#i';
				$replace[] = '<div id="_crc_' . $CRC_ID . '-" class="toggle_me tglWchild"></div>$1';
				$search[] = '#(<li class="(?:.+?)?groupNoChildren(?:.+?)?">\n\s+?<div class="(?:.+?)?categoryStrip(?:.+?)?>)#i';
				$replace[] = '$1<div class="toggle_me tglNOchild"></div>';

				$contents = preg_replace($search, $replace, $contents);
				unset ($search, $replace);
				
				//Let's now finalize the IDs of main categories adding to them their 'replacement order' number 
				
				$contents = preg_replace_callback('#_crc_\d{1,9}-#', 'ToggleME_Listener::regexcallback1', $contents);
				

				// Default Closed EXTRA Categories
				if (isset($options->toggleME_DefaultOff_ExtraCat))
				{
					$closed_cats = explode(',', $options->toggleME_DefaultOff_ExtraCat);

					foreach ($closed_cats as $closed_cat)
					{
						$search = '<div id="' . $closed_cat . '" class="toggle_me';
						$replace = $search . ' tglWOFF';
						$contents = str_replace($search, $replace, $contents);
					}
				}
		        } 
		        
		        //For postbit area
		        if ($hookName == 'message_user_info_text' AND $options->toggleME_selected_areas['postbit_extra'] AND $toggle_postbit_usr)
		        {    
				$search = '#(<h3 class="userText">)#i';
				$replace = '$1<div class="tglPosbit"></div>';

				$contents = preg_replace($search, $replace, $contents);
				unset ($search, $replace);
			}
			

		        //For sidebar blocks
		        if ($hookName == 'page_container_sidebar' AND $options->toggleME_selected_areas['widgets'] AND $toggle_widgets_usr)
		        {
				preg_match_all('#<div class="section(.*?)">#i', $contents, $matches_sb);
				$count = 1;
				
				if(isset($options->toggleME_Widgets_Exclude) AND isset($options->toggleME_Widgets_DefaultOff))
				{
					$widgets_options = self::BakeWidgetsOptions($options->toggleME_Widgets_Exclude, $options->toggleME_Widgets_DefaultOff);
				}
				
				//must be a string
				$excludes_withclass = $widgets_options['excludes_withclass'];
				$OFF_withclass  =  $widgets_options['OFF_withclass'];

				//must be an array AND only have numeric value (not full class name)
				$excludes_noclass = $widgets_options['excludes_noclass'];
				$OFF_noclass = $widgets_options['OFF_noclass'];
				
				foreach ($matches_sb[1] as $match_sb)
				{
					//Blocks with several class names
					if(!empty($match_sb) AND !preg_match('#\b' . $excludes_withclass . '\b#i', $match_sb))
					{
						$search = '#(<div class="section' . $match_sb . '">)#i';
						preg_match('#(\S+).*+#i', $match_sb, $block_id);
						
						if(!empty($OFF_withclass) AND preg_match('#\b' . $OFF_withclass . '\b#i', $match_sb))
						{
							$replace = '$1<div id="_'. $block_id[1] .'" class="tglSidebar tglSbOFF"></div>';
						}
						else
						{
							$replace = '$1<div id="_'. $block_id[1] .'" class="tglSidebar"></div>';
						}
		
						$contents = preg_replace($search, $replace, $contents);
						unset ($search, $replace);										
					}
					//Blocks with no class name except "section"
					elseif(empty($match_sb) AND !in_array($count, $excludes_noclass))
					{
						$search = '#<div class="section">#i';
						
						if(in_array($count, $OFF_noclass))
						{
							$replace = '<div class="section tglblock_' . $count . '"><div id="_tglblock_'. $count .'" class="tglSidebar tglSbOFF"></div>';						
						}
						else
						{
							$replace = '<div class="section tglblock_' . $count . '"><div id="_tglblock_'. $count .'" class="tglSidebar"></div>';
						}

						$contents = preg_replace($search, $replace, $contents, 1);
						unset ($search, $replace);
						$count++;					
					}
				
				}
		        }			
		}
	   }
	}
    
    	public static function regexcallback1($matches)
	{
		global $count;
		$count++;
		
		return $matches[0] . $count;
	}
	
	
	public static function BakeWidgetsOptions($excludes, $off)
	{
		//Init
		$output['excludes_withclass'] = '';
		$output['OFF_withclass'] = '';		
		$output['excludes_noclass'] = array();
		$output['OFF_noclass'] = array();

		//Bake excludes
		$wip_excludes = explode(',', $excludes);
		$i = 1;
		foreach ($wip_excludes as $exclude)
		{
			if(!empty($exclude))
			{
				if(preg_match('#tglblock_(\d+)#ui', $exclude ,$capture))
				{
					$output['excludes_noclass'][] = $capture[1];
				}
				else
				{
					if($i == 1)
					{
						$output['excludes_withclass'] .= $exclude;
					}
					else
					{
						$output['excludes_withclass'] .= '|' . $exclude;
					}
				}
			}
			$i++;
		}
		
		//Bake Off by default
		$wip_off= explode(',', $off);
		$i = 1;
		
		foreach($wip_off as $item)
		{
			if(!empty($item))
			{
				if(preg_match('#tglblock_(\d+)#ui', $item ,$capture))
				{
					$output['OFF_noclass'][] = $capture[1];
				}
				else
				{
					if($i == 1)
					{
						$output['OFF_withclass'] .= $item;
					}
					else
					{
						$output['OFF_withclass'] .= '|' . $item;
					}
				}
			}
			$i++;		
		}

		return $output;	
	}
    
	public static function template_postrender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		
           $options = XenForo_Application::get('options');

	   if ($options->toggleME_enabled)
           {
		$style_session = $template->getParam('visitorStyle');           
                $visitor = XenForo_Visitor::getInstance();
		$toggleMe_expand = new XenForo_Phrase('toggleMe_Expand');
		$toggleMe_collapse = new XenForo_Phrase('toggleMe_Collapse');
       	        $visitorUserGroupIds = array_merge(array((string)$visitor['user_group_id']), (explode(',', $visitor['secondary_group_ids'])));
		
		if(isset($options->toggleME_Usergroups_Postbit))
		{
			$toggle_postbit_usr = array_intersect($visitorUserGroupIds, $options->toggleME_Usergroups_Postbit);
		}
		if(isset($options->toggleME_styles))
		{
			$toggle_styles = in_array($style_session['style_id'], $options->toggleME_styles);			
		}
		if(isset($options->toggleME_Usergroups_Wrapped_Nodes))
		{
			$toggle_wrappednoded_usr = array_intersect($visitorUserGroupIds, $options->toggleME_Usergroups_Wrapped_Nodes);
		}
		if(isset($options->toggleME_Usergroups_Forumhome))
		{
			$toggle_forumhome_usr = array_intersect($visitorUserGroupIds, $options->toggleME_Usergroups_Forumhome);
		}		
				                
                if ($toggle_styles AND ($toggle_wrappednoded_usr OR $toggle_postbit_usr))
                {

		        if (($templateName == 'thread_view' OR $templateName == 'conversation_view') AND $options->toggleME_selected_areas['postbit_extra'] AND $toggle_postbit_usr)
		        {    
				$content = str_replace('<div class="extraUserInfo">', '<div class="extraUserInfo toggleHidden">', $content);

			}
	
		        if ($templateName == 'forum_view' AND $options->toggleME_selected_areas['node_subforums'] AND $toggle_wrappednoded_usr)
		        {    
		        	$NodeId = $template->getParam('nodeList');
		        	
		        	if($NodeId) // Needed conditional to avoid a error message on other nodes who don't have the "parentNodeId" variable
		        	{
			        	$NodeId = $NodeId['parentNodeId'];
		        
				        $search = '#(<ol.+?class="nodeList.+">)#';
				        $replace = '$1
				        <div id="tglnode_' . $NodeId . '" class="tglNodelist_forumview">
				        <span class="toggleME_Expand">' . $toggleMe_expand . '</span><span class="toggleME_Collapse">' . $toggleMe_collapse . '</span>
				        </div>';

					$content = preg_replace($search, $replace, $content);
				
					unset($search, $replace);
				}
			}


		        if ($templateName == 'node_category_level_1' AND $options->toggleME_selected_areas['node_categories'] AND $toggle_forumhome_usr)
		        {
			//For categories using by xenForo
			
				preg_match_all('#<li.+?class=".+?node_(?P<id>\d{1,9}).+?(?P<search><div class="categoryText">)#si', $content, $matches, PREG_SET_ORDER);
				
				foreach ($matches as $match)
				{
					
					if(isset($options->toggleME_DefaultOff_XenCat)) // I don't know if the isset condition is usefull here but I don't want any bloody scalar error
					{
						if (in_array($match['id'], $options->toggleME_DefaultOff_XenCat))
						{
							// Default Closed XenForo Categories?
							$content = preg_replace('#(<div class="categoryText">)#i', '<div id="_node_' . $match['id'] . '" class="toggle_me tglWOFF tglWchild"></div>$1', $content);
						}
						else
						{
							$content = preg_replace('#(<div class="categoryText">)#i', '<div id="_node_' . $match['id'] . '" class="toggle_me tglWchild"></div>$1', $content);
						}
					}
					else
					{
							$content = preg_replace('#(<div class="categoryText">)#i', '<div id="_node_' . $match['id'] . '" class="toggle_me tglWchild"></div>$1', $content); 
					}
				}
					
				$search = '#(<li class="(?:.+?)?groupNoChildren(?:.+?)?">\n\s+?<div class="(?:.+?)?categoryStrip(?:.+?)?>)#i';
				$replace = '$1<div class="toggle_me tglNOchild"></div>';

				$content = preg_replace($search, $replace, $content);

				unset ($search, $replace); 
			}
		}	
	   }
	}
}