<?php

class XenResource_Listener_Template
{
	protected static $_hasTemplatePerm = null;
	protected static $_resource = false;

	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if (self::$_hasTemplatePerm === null)
		{
			self::$_hasTemplatePerm = XenForo_Visitor::getInstance()->hasPermission('resource', 'view');
		}
		if (!self::$_hasTemplatePerm)
		{
			return;
		}

		switch ($templateName)
		{
			case 'account_alert_preferences':
				$template->preloadTemplate('account_alert_preferences_resources');
				break;

			case 'member_card':
				$template->preloadTemplate('member_card_resource_stats');
				break;

			case 'member_view':
				$template->preloadTemplate('member_view_resource_stats');
				$template->preloadTemplate('member_view_resource_tab_header');
				$template->preloadTemplate('member_view_resource_tab_content');
				break;

			case 'thread_view':
				$template->preloadTemplate('resource_view_tabs');
				$template->preloadTemplate('resource_view_header');
				break;
		}

		if (preg_match('/^search_form/', $templateName))
		{
			$template->preloadTemplate('search_forum_tabs_resource_update');
		}
	}

	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		if (!self::$_hasTemplatePerm)
		{
			return;
		}

		switch ($hookName)
		{
			case 'account_alerts_after_profile_posts':
				$contents .= $template->create('account_alert_preferences_resources', $template->getParams());
				break;

			case 'member_card_stats':
				$contents .= $template->create('member_card_resource_stats', $template->getParams());
				break;

			case 'member_view_info_block':
				$contents .= $template->create('member_view_resource_stats', $template->getParams());
				break;

			case 'member_view_tabs_heading':
				$contents .= $template->create('member_view_resource_tab_header', $template->getParams());
				break;

			case 'member_view_tabs_content':
				$contents .= $template->create('member_view_resource_tab_content', $template->getParams());
				break;

			case 'search_form_tabs':
				$contents .= $template->create('search_form_tabs_resource_update', $template->getParams());
				break;

			case 'thread_view_pagenav_before':
				if ($hookParams['thread']['discussion_type'] == 'resource')
				{
					/* @var $resourceModel XenResource_Model_Resource */
					$resourceModel = XenForo_Model::create('XenResource_Model_Resource');

					$fetchOptions = array(
						'join' => XenResource_Model_Resource::FETCH_CATEGORY
							| XenResource_Model_Resource::FETCH_USER
							| XenResource_Model_Resource::FETCH_ATTACHMENT
							| XenResource_Model_Resource::FETCH_VERSION,
						'watchUserId' => XenForo_Visitor::getUserId()
					);

					if (XenForo_Visitor::getInstance()->hasPermission('resource', 'viewDeleted')) {
						$fetchOptions['join'] |= XenResource_Model_Resource::FETCH_DELETION_LOG;
					}

					$resource = $resourceModel->getResourceByDiscussionId(
						$hookParams['thread']['thread_id'], $fetchOptions
					);
					if ($resource && $resourceModel->canViewResourceAndContainer($resource, $resource))
					{
						/* @var $categoryModel XenResource_Model_Category */
						$categoryModel = XenForo_Model::create('XenResource_Model_Category');

						$updateConditions = $categoryModel->getPermissionBasedFetchConditions($resource);
						if ($updateConditions['deleted'] === true || $updateConditions['moderated'] === true || $updateConditions['moderated'] == $resource['user_id'])
						{
							/* @var $updateModel XenResource_Model_Update */
							$updateModel = XenForo_Model::create('XenResource_Model_Update');

							$resourceUpdateCount = $updateModel->countUpdates(
								$updateConditions + array(
									'resource_id' => $resource['resource_id'],
									'resource_update_id_not' => $resource['description_update_id']
								)
							);
						}
						else
						{
							$resourceUpdateCount = $resource['update_count'];
						}

						$resource = $resourceModel->prepareResource($resource, $resource);
						$contents .= $template->create('resource_view_tabs',
							$template->getParams() + array(
								'resource' => $resource,
								'resourceUpdateCount' => $resourceUpdateCount,
								'selectedTab' => 'discussion'
							)
						);
						self::$_resource = $resource;
					}
				}
				break;
		}
	}

	public static function templatePostRender($templateName, &$contents, array &$containerData, XenForo_Template_Abstract $template)
	{
		if ($template instanceof XenForo_Template_Admin && $templateName == 'tools_rebuild')
		{
			$contents .= $template->create('tools_rebuild_resources', $template->getParams())->render();
		}

		if (self::$_resource && $templateName == 'thread_view')
		{
			$contents =
				$template->create('resource_view_header', $template->getParams() + array(
					'resource' => self::$_resource,
					'titleHtml' => (isset($containerData['h1']) ? $containerData['h1'] : false),
					/*'extraDescriptionHtml' => (isset($containerData['pageDescription']['content'])
						? $containerData['pageDescription']['content']
						: false
					)*/
				)) . $contents;

			$containerData['h1'] = '';
		}
	}

	public static function navigationTabs(&$extraTabs, $selectedTabId)
	{
		if (XenForo_Visitor::getInstance()->hasPermission('resource', 'view'))
		{
			$extraTabs['resources'] = array(
				'title' => new XenForo_Phrase('resources'),
				'href' => XenForo_Link::buildPublicLink('full:resources'),
				'position' => 'middle',
				'linksTemplate' => 'resources_tab_links'
			);
		}
	}
}