<?php
class XenPlaza_XPPollPermission_ControllerPublic_Thread extends XFCP_XenPlaza_XPPollPermission_ControllerPublic_Thread
{
	public function actionIndex()
	{
		$result = parent::actionIndex();		
		
		if(isset($result->params['poll']['canVote'])){
			$visitor = XenForo_Visitor::getInstance();
			
			$reason = array();
			if(isset($result->params['thread']['node_id']) && $visitor['user_id']){
				$nodePermissions = $visitor->getNodePermissions($result->params['thread']['node_id']);
				
				$numPost = XenForo_Permission::hasContentPermission($nodePermissions, 'XPPPNumPost');
				$numLike = XenForo_Permission::hasContentPermission($nodePermissions, 'XPPPNumLike');
				$numAge = XenForo_Permission::hasContentPermission($nodePermissions, 'XPPPNumAge');
				$numReg = XenForo_Permission::hasContentPermission($nodePermissions, 'XPPPRegisterAfter');
				
				$userProfileModel = $this->getModelFromCache('XenForo_Model_UserProfile');
				if($numPost && $visitor['message_count']<$numPost){
					$result->params['poll']['canVote'] = 0;
					$reason[] = new XenForo_Phrase('XPPP_your_post_must_more_than_x',array(
						'num_post' => $numPost
					));
				}
				if($numLike && $visitor['like_count']<$numLike){
					$result->params['poll']['canVote'] = 0;
					$reason[] = new XenForo_Phrase('XPPP_your_like_must_more_than_x',array(
						'num_like' => $numLike
					));
				}
				if($numAge && $userProfileModel->getUserAge($visitor->toArray()) < $numAge){
					$result->params['poll']['canVote'] = 0;
					$reason[] = new XenForo_Phrase('XPPP_your_age_must_more_than_x',array(
						'num_age' => $numAge
					));
				}
				if(!$numReg){
					if($visitor['register_date'] > $result->params['thread']['post_date']){
						$result->params['poll']['canVote'] = 0;
						$reason[] = new XenForo_Phrase('XPPP_your_register_time_too_late');
					}
				}
				$result->params['poll']['reasons'] = $reason;
			}				
		}
		return $result;
	}
}
?>