<?php

class XenGallery_Option_CategoryChooser
{
	/**
	* Gallery Category chooser. Displays a list of nodes. Rendered in a multiple choice select element
	*/
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$preparedOption['options'] = array();
		
		$categories = XenForo_Model::create('XenGallery_Model_Category')->getCategoryStructure();
		
		if ($categories)
		{
			foreach ($categories AS $key => $category)
			{
				$preparedOption['options'][$category['xengallery_category_id']] = array(
					'xengallery_category_id' => $category['xengallery_category_id'],
					'title' => $category['category_title'],
					'depth' => str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;', $category['depth']),
					'selected' => in_array($categories[$key]['xengallery_category_id'], $preparedOption['option_value'])
				);
			}			
		}
		
		return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
			'xengallery_category_chooser', $view, $fieldPrefix, $preparedOption, $canEdit
		);		
	}
}