<?php

/**
 * News feed handler for media rating actions
 *
 * @author kier
 *
 */
class XenGallery_NewsFeedHandler_Rating extends XenForo_NewsFeedHandler_Abstract
{
	protected $_ratingModel;

	/**
	 * Just returns a value for each requested ID
	 * but does no actual DB work
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_NewsFeed $model
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, array $viewingUser)
	{
		$ratingModel = $this->_getRatingModel();

		$rating = $ratingModel->getRatingsByIds($contentIds, array(
			'join' => XenGallery_Model_Rating::FETCH_USER | XenGallery_Model_Rating::FETCH_MEDIA
		));
		$rating = XenForo_Model::create('XenGallery_Model_Media')->prepareMedia($rating);

		return $rating;
	}

	/**
	 * Determines if the given news feed item is viewable.
	 *
	 * @param array $item
	 * @param mixed $content
	 * @param array $viewingUser
	 *
	 * @return boolean
	 */
	public function canViewNewsFeedItem(array $item, $content, array $viewingUser)
	{
		return XenForo_Model::create('XenGallery_Model_Media')->canViewMedia();
	}

	/**
	 * @return XenGallery_Model_Rating
	 */
	protected function _getRatingModel()
	{
		if (!$this->_ratingModel)
		{
			$this->_ratingModel = XenForo_Model::create('XenGallery_Model_Rating');
		}

		return $this->_ratingModel;
	}
}