<?php

/**
 * News feed handler for media actions
 *
 * @author kier
 *
 */
class XenGallery_NewsFeedHandler_Media extends XenForo_NewsFeedHandler_Abstract
{
	protected $_mediaModel;
	protected $_attachmentModel;

	/**
	 * Just returns a value for each requested ID
	 * but does no actual DB work
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_NewsFeed $model
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, array $viewingUser)
	{
		$mediaModel = $this->_getMediaModel();

		$media = $mediaModel->getMediaByIds($contentIds, array(
			'join' => XenGallery_Model_Media::FETCH_CATEGORY | XenGallery_Model_Media::FETCH_USER | XenGallery_Model_Media::FETCH_ATTACHMENT
		));
		
		foreach ($media AS $key => &$item)
		{
			if ($item['media_state'] != 'visible')
			{
				unset ($media[$key]);
			}
		}
		
		$media = $mediaModel->prepareMediaItems($media);

		return $media;
	}

	/**
	 * Determines if the given news feed item is viewable.
	 *
	 * @param array $item
	 * @param mixed $content
	 * @param array $viewingUser
	 *
	 * @return boolean
	 */
	public function canViewNewsFeedItem(array $item, $content, array $viewingUser)
	{
		return $this->_mediaModel->canViewMedia();
	}

	/**
	 * @return XenGallery_Model_Media
	 */
	protected function _getMediaModel()
	{
		if (!$this->_mediaModel)
		{
			$this->_mediaModel = XenForo_Model::create('XenGallery_Model_Media');
		}

		return $this->_mediaModel;
	}
	
	/**
	 * @return XenForo_Model_Attachment
	 */
	protected function _getAttachmentModel()
	{
		if (!$this->_attachmentModel)
		{
			$this->_attachmentModel = XenForo_Model::create('XenForo_Model_Attachment');
		}

		return $this->_attachmentModel;
	}	
}