<?php

/**
 * News feed handler for media comment actions
 *
 * @author kier
 *
 */
class XenGallery_NewsFeedHandler_Comment extends XenForo_NewsFeedHandler_Abstract
{
	protected $_commentModel;

	/**
	 * Just returns a value for each requested ID
	 * but does no actual DB work
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_NewsFeed $model
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, array $viewingUser)
	{
		$commentModel = $this->_getCommentModel();

		$comment = $commentModel->getComments(array('comment_id' => $contentIds), array(
			'join' => XenGallery_Model_Comment::FETCH_CATEGORY | XenGallery_Model_Comment::FETCH_USER | XenGallery_Model_Comment::FETCH_ATTACHMENT | XenGallery_Model_Comment::FETCH_MEDIA
		));

		return $comment;
	}

	/**
	 * Determines if the given news feed item is viewable.
	 *
	 * @param array $item
	 * @param mixed $content
	 * @param array $viewingUser
	 *
	 * @return boolean
	 */
	public function canViewNewsFeedItem(array $item, $content, array $viewingUser)
	{
		return XenForo_Model::create('XenGallery_Model_Media')->canViewMedia();
	}

	/**
	 * @return XenGallery_Model_Comment
	 */
	protected function _getCommentModel()
	{
		if (!$this->_commentModel)
		{
			$this->_commentModel = XenForo_Model::create('XenGallery_Model_Comment');
		}

		return $this->_commentModel;
	}
}