<?php

class XenGallery_Model_Option extends XenForo_Model
{
    /**
     * Gets a list of BB Code Media Sites as options (for checkbox/multi-select usage).
     *
     * @param string|array $selectedGroupIds Array or comma delimited list
     *
     * @return array
     */
    public function getUserGroupOptions($selectedMediaSiteIds)
    {
        if (!is_array($selectedMediaSiteIds))
        {
            $selectedMediaSiteIds = ($selectedMediaSiteIds ? explode(',', $selectedMediaSiteIds) : array());
        }

        $mediaSites = array();
        foreach ($this->getModelFromCache('XenForo_Model_BbCode')->getAllBbCodeMediaSites() AS $mediaSite)
        {
            $mediaSites[] = array(
                'label' => $mediaSite['site_title'],
                'value' => $mediaSite['media_site_id'],
                'selected' => in_array($mediaSite['media_site_id'], $selectedMediaSiteIds)
            );
        }

        return $mediaSites;
    }
}