<?php

class XenGallery_Install
{
	public static function installer($installedAddon)
	{
		$db = XenForo_Application::getDb();
		XenForo_Db::beginTransaction($db);
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `xengallery_category` (
			  `xengallery_category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `category_title` varchar(100) NOT NULL,
			  `category_description` text NOT NULL,
			  `upload_user_groups` blob NOT NULL,			  
			  `parent_category_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `display_order` int(10) unsigned NOT NULL DEFAULT '0',
			  `category_breadcrumb` blob NOT NULL,
			  `depth` smallint(5) unsigned NOT NULL DEFAULT '0',
			  PRIMARY KEY (`xengallery_category_id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8		
		");
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `xengallery_media` (
			  `media_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `media_title` varchar(100) NOT NULL,
			  `media_description` varchar(200) NOT NULL,
			  `media_caption` text,
			  `media_date` int(10) unsigned NOT NULL DEFAULT '0',
			  `last_comment_date` int(10) unsigned NOT NULL DEFAULT '0',
			  `media_type` enum('image_upload','video_embed') NOT NULL DEFAULT 'image_upload',
			  `media_tag` varchar(100) DEFAULT NULL,
			  `media_embed_url` text,
			  `media_state` enum('visible','moderated','deleted') NOT NULL DEFAULT 'visible',
			  `xengallery_category_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `attachment_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `username` varchar(50) NOT NULL,
			  `ip_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `likes` int(10) unsigned NOT NULL DEFAULT '0',
			  `like_users` blob,
			  `comment_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `view_count` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
			  `rating_avg` float unsigned NOT NULL DEFAULT '0',
			  PRIMARY KEY (`media_id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8
		");
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `xengallery_media_user_view` (
			  `media_view_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `user_id` int(10) unsigned NOT NULL,
			  `media_id` int(10) unsigned NOT NULL,
			  `media_view_date` int(10) unsigned NOT NULL,
			  PRIMARY KEY (`media_view_id`),
			  UNIQUE KEY `user_id_media_id` (`user_id`,`media_id`),
			  KEY `media_id` (`media_id`),
			  KEY `media_view_date` (`media_view_date`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8		
		");
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `xengallery_media_view` (
			  `media_id` int(10) unsigned NOT NULL,
			  KEY `media_id` (`media_id`)
			) ENGINE=MEMORY DEFAULT CHARSET=utf8		
		");
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `xengallery_comment` (
			  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `media_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `media_comment` mediumtext NOT NULL,
			  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `username` varchar(50) NOT NULL DEFAULT '',
			  `ip_id` int(10) unsigned NOT NULL DEFAULT '0',			  
			  `comment_date` int(10) unsigned NOT NULL DEFAULT '0',
			  `comment_state` enum('visible','moderated','deleted') NOT NULL DEFAULT 'visible',
			  `rating_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `likes` int(10) unsigned NOT NULL DEFAULT '0',
			  `like_users` blob,
			  PRIMARY KEY (`comment_id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8		
		");
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `xengallery_rating` (
			  `media_rating_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `user_id` int(10) unsigned NOT NULL,
			  `username` varchar(50) NOT NULL DEFAULT '',
			  `rating` tinyint(3) unsigned NOT NULL,
			  `rating_date` int(10) unsigned NOT NULL,
			  `media_id` int(10) unsigned NOT NULL,
			  PRIMARY KEY (`media_rating_id`),
			  UNIQUE KEY `media_user_id` (`media_id`,`user_id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8		
		");
		
		$version = is_array($installedAddon) ? $installedAddon['version_id'] : 0;
		
		if ($version < 110)
		{
            self::addRemoveColumn('xengallery_media', 'media_caption', 'add', "TEXT", 'media_description');
            self::addRemoveColumn('xengallery_media', 'media_type', 'add', "ENUM('image','video') NOT NULL DEFAULT 'image'", 'media_date');
            self::addRemoveColumn('xengallery_media', 'media_tag', 'add', "TEXT", 'media_type');
            self::addRemoveColumn('xengallery_media', 'view_count', 'add', "int(10) unsigned NOT NULL DEFAULT '0'", 'rating_count');
            
            self::addRemoveColumn('xengallery_category', 'allowed_types', 'add', "BLOB NOT NULL", 'upload_user_groups');
                    
            self::addRemoveColumn('xengallery_media', 'media_embed_url', 'add', "TEXT", 'media_tag');
			
			$mediaViewCounts = $db->fetchPairs('
				SELECT attachment_id, view_count
				FROM xf_attachment
				WHERE content_type = \'xengallery_media\'
			');
			
			foreach ($mediaViewCounts AS $key => $count)
			{
				$attachmentId = $db->quote($key);
				$db->update('xengallery_media', array('view_count' => $count), 'attachment_id = ' . $attachmentId);
			}
			
			self::addRemoveColumn('xengallery_category', 'allowed_types', 'add', "BLOB NOT NULL", 'upload_user_groups');
			$db->query('UPDATE `xengallery_category` SET `allowed_types`= \'a:1:{i:0;s:3:"all";}\'');
		}	
        
        if ($version < 112)	
        {
            $db->query("ALTER TABLE `xengallery_media` CHANGE COLUMN `media_type` `media_type` ENUM('image','video','image_upload','video_embed') NOT NULL DEFAULT 'image'");
            
            $db->query("UPDATE xengallery_media SET media_type = 'image_upload' WHERE media_type = 'image'");
            $db->query("UPDATE xengallery_media SET media_type = 'video_embed' WHERE media_type = 'video'");
            
            $db->query("ALTER TABLE `xengallery_media` CHANGE COLUMN `media_type` `media_type` ENUM('image_upload','video_embed') NOT NULL DEFAULT 'image_upload'");
        }
        
        if ($version < 120)
        {
			self::addRemoveColumn('xengallery_media', 'last_comment_date', 'add', "INT(10) NOT NULL DEFAULT '0'", 'media_date');
        }
        
        if ($version < 127)
        {
        	$media = $db->fetchPairs('
        		SELECT media_id, attachment_id
        		FROM xengallery_media
        		WHERE media_type = \'image_upload\'
        	');
        	
        	foreach ($media AS $contentId => $attachmentId)
        	{
        		$db->update('xf_attachment', array('content_id' => $contentId), 'attachment_id = ' . $db->quote($attachmentId));
        	}
        }
        
        $db->update('xf_content_type', array('addon_id' => 'XenGallery'), "content_type IN ('xengallery', 'xengallery_media', 'xengallery_comment', 'xengallery_rating')");

		$xenGalleryFields = array(
			'stats_handler_class' => 'XenGallery_StatsHandler_Gallery'
		);
		$xenGalleryFields = serialize($xenGalleryFields);
		
        // Add XenGallery Global Content Type
		$db->query('
			INSERT INTO xf_content_type
				(content_type, addon_id, fields)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE fields = VALUES(fields)
		', array('xengallery', 'XenGallery', $xenGalleryFields));		
		
        // Add XenGallery Content Type Field (Stats)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery', 'stats_handler_class', 'XenGallery_StatsHandler_Gallery'));				
		
        $xenGalleryMediaFields = array(
            'alert_handler_class' => 'XenGallery_AlertHandler_Media',
            'attachment_handler_class' => 'XenGallery_AttachmentHandler_Media',
            'like_handler_class' => 'XenGallery_LikeHandler_Media',
            'report_handler_class' => 'XenGallery_ReportHandler_Media',
            'news_feed_handler_class' => 'XenGallery_NewsFeedHandler_Media',
            'moderation_queue_handler_class' => 'XenGallery_ModerationQueueHandler_Media',
            'search_handler_class' => 'XenGallery_Search_DataHandler_Media'
        );
        $xenGalleryMediaFields = serialize($xenGalleryMediaFields);
        
        // Add XenGallery Media Content Type
		$db->query('
			INSERT INTO xf_content_type
				(content_type, addon_id, fields)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE fields = VALUES(fields)
		', array('xengallery_media', 'XenGallery', $xenGalleryMediaFields));
		
        // Add XenGallery Media Content Type Field (Attachments)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_media', 'attachment_handler_class', 'XenGallery_AttachmentHandler_Media'));				                
		
		// Add XenGallery Media Content Type Field (Likes)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_media', 'like_handler_class', 'XenGallery_LikeHandler_Media'));				
		
		// Add XenGallery Media Content Type Field (Alerts)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_media', 'alert_handler_class', 'XenGallery_AlertHandler_Media'));
		
		// Add XenGallery Media Content Type Field (Reports)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_media', 'report_handler_class', 'XenGallery_ReportHandler_Media'));
		
		// Add XenGallery Media Content Type Field (News Feed)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_media', 'news_feed_handler_class', 'XenGallery_NewsFeedHandler_Media'));
		
		// Add XenGallery Media Content Type Field (Moderation Queue)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_media', 'moderation_queue_handler_class', 'XenGallery_ModerationQueueHandler_Media'));
		
		// Add XenGallery Media Content Type Field (Search)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_media', 'search_handler_class', 'XenGallery_Search_DataHandler_Media'));		
		
        $xenGalleryCommentFields = array(
            'alert_handler_class' => 'XenGallery_AlertHandler_Comment',
            'report_handler_class' => 'XenGallery_ReportHandler_Comment',
            'like_handler_class' => 'XenGallery_LikeHandler_Comment',
            'news_feed_handler_class' => 'XenGallery_NewsFeedHandler_Comment'
        );
        $xenGalleryCommentFields = serialize($xenGalleryCommentFields);
        
        // Add XenGallery Comments Content Type
		$db->query('
			INSERT INTO xf_content_type
				(content_type, addon_id, fields)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE fields = VALUES(fields)
		', array('xengallery_comment', 'XenGallery', $xenGalleryCommentFields));        
        
		// Add XenGallery Comment Content Type Field (Alerts)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_comment', 'alert_handler_class', 'XenGallery_AlertHandler_Comment'));
		
		// Add XenGallery Comment Content Type Field (Reports)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_comment', 'report_handler_class', 'XenGallery_ReportHandler_Comment'));
		
		// Add XenGallery Comment Content Type Field (Likes)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_comment', 'like_handler_class', 'XenGallery_LikeHandler_Comment'));
		
		// Add XenGallery Comment Content Type Field (News Feed)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_comment', 'news_feed_handler_class', 'XenGallery_NewsFeedHandler_Comment'));		
		
        $xenGalleryRatingFields = array(
            'alert_handler_class' => 'XenGallery_AlertHandler_Rating',        
            'news_feed_handler_class' => 'XenGallery_NewsFeedHandler_Rating'
        );
        $xenGalleryRatingFields = serialize($xenGalleryRatingFields);		
        
        // Add XenGallery Rating Content Type
		$db->query('
			INSERT INTO xf_content_type
				(content_type, addon_id, fields)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE fields = VALUES(fields)
		', array('xengallery_rating', 'XenGallery', $xenGalleryRatingFields));        
        
		// Add XenGallery Rating Content Type Field (News Feed)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_rating', 'news_feed_handler_class', 'XenGallery_NewsFeedHandler_Rating'));
		
		// Add XenGallery Rating Content Type Field (Alerts)
		$db->query('
			INSERT INTO xf_content_type_field
				(content_type, field_name, field_value)
			VALUES
				(?, ?, ?)
			ON DUPLICATE KEY UPDATE field_value = VALUES(field_value)
		', array('xengallery_rating', 'alert_handler_class', 'XenGallery_AlertHandler_Rating'));		
		
		self::addRemoveColumn('xf_user', 'media_count', 'add', "int(10) unsigned NOT NULL DEFAULT '0'", 'warning_points');
		
		XenForo_Db::commit($db);
	}
	
	public static function uninstaller()
	{
		$db = XenForo_Application::getDb();
		XenForo_Db::beginTransaction($db);
		
		$db->query('
			DROP TABLE IF EXISTS xengallery_category
		');
		
		$db->query('
			DROP TABLE IF EXISTS xengallery_media
		');
		
		$db->query('
			DROP TABLE IF EXISTS xengallery_comment
		');
		
		$db->query('
			DROP TABLE IF EXISTS xengallery_rating
		');
		
		$db->query('
			DROP TABLE IF EXISTS xengallery_media_view
		');
		
		$db->query('
			DROP TABLE IF EXISTS xengallery_media_user_view	
		');
		
		self::addRemoveColumn('xf_user', 'media_count');
		
		$contentTypes = array('xengallery_media', 'xengallery_comment', 'xengallery_rating');
		$contentTypesQuoted = $db->quote($contentTypes);

		$contentTypeTables = array(
			'xf_attachment',
			'xf_content_type',
			'xf_content_type_field',
			'xf_deletion_log',
			'xf_liked_content',
			'xf_moderation_queue',
			'xf_news_feed',
			'xf_report',
			'xf_user_alert'
		);
		foreach ($contentTypeTables AS $table)
		{
			$db->delete($table, 'content_type IN (' . $contentTypesQuoted . ')');
		}		
		
		XenForo_Db::commit($db);	
	}
	
	public static function addRemoveColumn($tableName, $columnName, $action = 'remove', $columnDef = NULL, $after = NULL)
	{
		$db = XenForo_Application::get('db');
		$exists = self::doesColumnExist($tableName, $columnName);
		
		if ($action === 'remove')
		{
			if ($exists)
			{
    			$db->query("
    					ALTER TABLE {$tableName} DROP COLUMN {$columnName}
    			");				
			}
		}
		elseif ($action === 'add')
		{
			if (!$exists)
			{
    			$db->query("
    					ALTER TABLE {$tableName} ADD {$columnName} {$columnDef} AFTER {$after}
    			");
			}			
		}
	}
	
	public static function doesColumnExist($tableName, $columnName)
	{
    	$db = XenForo_Application::get('db');
    
    	return $db->fetchRow("
			SHOW COLUMNS
			FROM $tableName
			WHERE Field = ?
		", $columnName);
	}	
}