<?php

class XenGallery_ControllerPublic_Attachment extends XFCP_XenGallery_ControllerPublic_Attachment
{
	public function actionIndex()
	{	
		$attachmentId = $this->_input->filterSingle('attachment_id', XenForo_Input::UINT);
		$attachment = $this->_getAttachmentOrError($attachmentId);
		
		if ($attachment['content_type'] == 'xengallery_media')
		{
			$mediaModel = $this->_getMediaModel();
			$mediaId = $mediaModel->getMediaIdByAttachmentId($attachmentId);
			$media = $this->_getMediaHelper()->assertMediaValidAndViewable($mediaId);
		}
		
		return parent::actionIndex();
	}
	
	/**
	 * @return XenGallery_ControllerHelper_Media
	 */
	protected function _getMediaHelper()
	{
		return $this->getHelper('XenGallery_ControllerHelper_Media');
	}	
	
	/**
	 * @return XenGallery_Model_Media
	 */	
	protected function _getMediaModel()
	{
		return $this->getModelFromCache('XenGallery_Model_Media');
	}
}