<?php

class XenGallery_CacheRebuilder_Thumbnail extends XenForo_CacheRebuilder_Abstract
{
	/**
	* Database object
	*
	* @var Zend_Db_Adapter_Abstract
	*/
	protected $_db = null;
	
	/**
	 * Gets rebuild message.
	 */
	public function getRebuildMessage()
	{
		return new XenForo_Phrase('xengallery_media');
	}

	/**
	 * Shows the exit link.
	 */
	public function showExitLink()
	{
		return true;
	}

	/**
	 * Rebuilds the data.
	 *
	 * @see XenForo_CacheRebuilder_Abstract::rebuild()
	 */
	public function rebuild($position = 0, array &$options = array(), &$detailedMessage = '')
	{
		$options['batch'] = max(1, isset($options['batch']) ? $options['batch'] : 10);

		/* @var $mediaModel XenGallery_Model_Media */
		$mediaModel = XenForo_Model::create('XenGallery_Model_Media');

		$mediaIds = $mediaModel->getMediaIdsInRange($position, $options['batch']);
		if (sizeof($mediaIds) == 0)
		{
			return true;
		}
		
		$attachmentModel = XenForo_Model::create('XenForo_Model_Attachment');

		XenForo_Db::beginTransaction();
		
		$fetchOptions = array(
			'join' => XenGallery_Model_Media::FETCH_ATTACHMENT
		);
		
		$media = $mediaModel->getMediaByIds($mediaIds, $fetchOptions);
		foreach ($media AS $item)
		{
			$position = $item['media_id'];
			
			$thumbnailPath = $mediaModel->getMediaThumbnailFilePath($item);
			$dataPath = XenForo_Model::create('XenForo_Model_Attachment')->getAttachmentDataFilePath($item);
			
			if (!is_file($dataPath))
			{
				continue;
			}
			
			XenForo_Helper_File::createDirectory($mediaModel->getThumbnailFilePath($item), true);
			
			$data = getimagesize($dataPath);
			$imageType = $data[2];
			
			$image = XenForo_Image_Abstract::createFromFile($dataPath, $imageType);
			if ($image)
			{   
				$thumbnailDimension = XenForo_Application::get('options')->xengalleryThumbnailDimensions;

				$imageOrientation = $image->getOrientation();
				$imageWidth = $image->getWidth();
				$imageHeight = $image->getHeight();

				$hasThumbnailed = false;

                switch ($imageOrientation)
                {
					case 'square':
					
	                    $image->thumbnail($thumbnailDimension);
	                    $hasThumbnailed = true;					
	                        
						break;
						
					case 'landscape':
					
	                    $image->thumbnailFixedShorterSide($thumbnailDimension);
	                    
	                    $imageWidth = $image->getWidth();
	                    
	                    $image->crop(($imageWidth / 2) - ($thumbnailDimension / 2), 0, $thumbnailDimension, $thumbnailDimension);
	                    
	                    $hasThumbnailed = true;						
	                    
						break;
						
					case 'portrait':
					
	                    $image->thumbnailFixedShorterSide($thumbnailDimension);
	                    
	                    $imageHeight = $image->getHeight();
	                 
	                    $image->crop(0, ($imageHeight / 2) - ($thumbnailDimension / 2), $thumbnailDimension, $thumbnailDimension);
	                    
	                    $hasThumbnailed = true;
	                    
	                    break;
                }

				if ($hasThumbnailed)
				{
					$image->output($imageType, $thumbnailPath);
				}
				else
				{
					copy($dataPath, $thumbnailPath); // no resize necessary, use the original
				}

				$dimensions['thumbnail_width'] = $image->getWidth();
				$dimensions['thumbnail_height'] = $image->getHeight();

				unset($image);
				
				if ($this->_db === null)
				{
					$this->_db = XenForo_Application::getDb();
				}
				
				$this->_db->update('xf_attachment_data', $dimensions, 'data_id = ' . $this->_db->quote($item['data_id']));
			}
		}
		
		XenForo_Db::commit();
		
		$detailedMessage = XenForo_Locale::numberFormat($position);

		return $position;		
	}
}