<?php

class XenGallery_CacheRebuilder_MediaCount extends XenForo_CacheRebuilder_Abstract
{
	/**
	 * Gets rebuild message.
	 */
	public function getRebuildMessage()
	{
		return new XenForo_Phrase('xengallery_media');
	}

	/**
	 * Shows the exit link.
	 */
	public function showExitLink()
	{
		return true;
	}

	/**
	 * Rebuilds the data.
	 *
	 * @see XenForo_CacheRebuilder_Abstract::rebuild()
	 */
	public function rebuild($position = 0, array &$options = array(), &$detailedMessage = '')
	{
		$options['batch'] = max(1, isset($options['batch']) ? $options['batch'] : 10);

		/* @var $mediaModel XenGallery_Model_Media */
		$mediaModel = XenForo_Model::create('XenGallery_Model_Media');
		
		/* @var $mediaModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');		

		$userIds = $userModel->getUserIdsInRange($position, $options['batch']);
		if (sizeof($userIds) == 0)
		{
			return true;
		}
		
		foreach ($userIds AS $userId)
		{
			$position = $userId;
			
		}
		
		$mediaModel->rebuildUserMediaCounts($userIds);
		
		$detailedMessage = XenForo_Locale::numberFormat($position);

		return $position;		
	}
}
