<?php

class XenGallery_AlertHandler_Comment extends XenForo_AlertHandler_Abstract
{
	protected $_commentModel;

	/**
	 * Fetches the content required by alerts.
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_Alert $model Alert model invoking this
	 * @param integer $userId User ID the alerts are for
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		$commentModel = $this->_getCommentModel();
		$mediaModel = XenForo_Model::create('XenGallery_Model_Media');
		
		$conditions = array(
			'comment_id' => $contentIds
		);
		
		$fetchOptions = array(
			'join' => XenGallery_Model_Comment::FETCH_USER | XenGallery_Model_Comment::FETCH_MEDIA
		);
		
		$comments = $commentModel->getComments($conditions, $fetchOptions);

		foreach ($comments AS $key => &$comment)
		{
			if (!$mediaModel->canViewMedia())
			{
				unset($comments[$key]);
			}
			
			$comment['media_type'] = new XenForo_Phrase('xengallery_image_lower');
		}
	
		return $comments;
	}

	/**
	* Determines if the comment is viewable.
	* @see XenForo_AlertHandler_Abstract::canViewAlert()
	*/
	public function canViewAlert(array $alert, $content, array $viewingUser)
	{	
		return true;
	}

	/**
	 * @return XenGallery_Model_Comment
	 */
	protected function _getCommentModel()
	{
		if (!$this->_commentModel)
		{
			$this->_commentModel = XenForo_Model::create('XenGallery_Model_Comment');
		}

		return $this->_commentModel;
	}	
}
