<?php

class WdbPopularContent_ControllerPublic_Index extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		return $this->_getContent('threads');
	}
	
	public function actionThreads()
	{
		return $this->_getContent('threads');
	}
	
	public function actionPosts()
	{
		return $this->_getContent('posts');
	}
	
	public function actionContent()
	{
		$contentType='threads';
		if ((isset($_GET['type']))&&($_GET['type']=='posts')) {
			$contentType='posts';
		}
		return $this->_getContent($contentType);
	}

	public static function getSessionActivityDetailsForList(array $activities)
	{
		return new XenForo_Phrase('wdb_popular_content_location_phrase');
	}


	protected function _getContent($contentType='threads')
	{

		$timeFrame = $this->_input->filterSingle('url_id', XenForo_Input::UINT);
		if (!$timeFrame) $timeFrame=2;

		$maxResults = XenForo_Application::get('options')->wdbPopularContentMaximumResults;

		$data = $this->_getPopularContentModel()->getPopularContent($maxResults,$timeFrame,$contentType);

		$viewParams = array(
				'contentType'=>$contentType,
				'timeFrame'=>$timeFrame,
				'posts'=>$data['posts'],
				'queryDate'=>$data['queryDate']
		);
		return $this->responseView('WdbPopularContent_ViewPublic_Index','wdb_popular_content', $viewParams);
	}


	/**
	 * @return PopularThreads_Model_PopularThreads
	 */
	protected function _getPopularContentModel()
	{
		return $this->getModelFromCache('WdbPopularContent_Model_PopularContent');
	}

}