<?php

class Waindigo_PostAsUser_Listener_TemplateCreate extends Waindigo_Listener_TemplateCreate
{
	public function run() {
		switch ($this->_templateName)
		{
			case 'thread_view':
				$this->_threadView();
				break;
			case 'thread_create':
				$this->_threadCreate();
				break;
		}
		return parent::run();
	}
	
	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		$templateCreate = new Waindigo_PostAsUser_Listener_TemplateCreate($templateName, $params, $template);
		list($templateName, $params) = $templateCreate->run();
	}
	
	protected function _threadCreate()
	{
		$this->_preloadTemplate('waindigo_post_as_user_field_postasuser');
	}
	
	protected function _threadView()
	{
		$this->_preloadTemplates(array(
			'waindigo_quick_reply_prepend_postasuser',
			'waindigo_post_as_user_field_postasuser',
		));
	}
}