<?php

class Waindigo_PostAsUser_ControllerPublic_Member extends XFCP_Waindigo_PostAsUser_ControllerPublic_Member
{
	public function actionFindPostAsUserAutoCombo()
	{
		$q = $this->_input->filterSingle('q', XenForo_Input::STRING);
	
		if ($this->_getUserModel()->canPostAsDifferentUser())
		{
			$userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_postAsUser_userGroups);
		
			if (!empty($userGroupIds))
			{
				$conditions = array();
				if ($q) $conditions['username'] = array($q , 'r');
				$users = $this->_getUserModel()->getUsersByUserGroupIds($userGroupIds, $conditions);
				unset($users[XenForo_Visitor::getUserId()]);
			}
		}
		else
		{
			$users = array();
		}
		
		$viewParams = array(
				'users' => $users
		);
	
		return $this->responseView(
				'XenForo_ViewPublic_Member_Find',
				'member_autocomplete',
				$viewParams
		);
	}
	
	public function actionFindPostAsUser()
	{
		$q = $this->_input->filterSingle('q', XenForo_Input::STRING);
	
		if ($this->_getUserModel()->canPostAsDifferentUser())
		{
			$userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_postAsUser_userGroups);
	
			if (!empty($userGroupIds) && $q !== '' && utf8_strlen($q) >= 2)
			{
				$conditions['username'] = array($q , 'r');
				$users = $this->_getUserModel()->getUsersByUserGroupIds($userGroupIds, $conditions);
				unset($users[XenForo_Visitor::getUserId()]);
			}
		}
		else
		{
			$users = array();
		}
	
		$viewParams = array(
				'users' => $users
		);
	
		return $this->responseView(
				'XenForo_ViewPublic_Member_Find',
				'member_autocomplete',
				$viewParams
		);
	}	
}