<?php

class Waindigo_LoginAsUser_Listener_TemplateHook extends Waindigo_Listener_TemplateHook
{
	public function run() {
		switch ($this->_hookName)
		{
			case 'body':
				$this->_body();
				break;
			case 'moderator_bar':
				$this->_moderatorBar();
				break;
			case 'member_card_links':
				$this->_memberCardLinks();
				break;
		}
		return parent::run();
	}
	
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		$templateHook = new Waindigo_LoginAsUser_Listener_TemplateHook($hookName, $contents, $hookParams, $template);
		$contents = $templateHook->run();
	}
	
	protected function _body()
	{
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');
		
		$viewParams = $this->_fetchViewParams();
		
		/* @var $session XenForo_Session */
		$session = XenForo_Application::get('session');
		if ($session->isRegistered('loggedInAs') || $userModel->canLoginAsUsers())
		{
			if (!XenForo_Visitor::getInstance()->is_admin && !XenForo_Visitor::getInstance()->is_moderator)
			{
				if ($session->isRegistered('loggedInAs'))
				{
					$viewParams['parentVisitor'] = Waindigo_LoginAsUser_Visitor::getParentInstance()->toArray();
				}
				$viewParams['hideLoginBar'] = true;
				$this->_prependTemplate('waindigo_moderator_bar_loginasuser', $viewParams);
			}
		}
	}
	
	protected function _moderatorBar()
	{
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');

		$viewParams = $this->_fetchViewParams();
		
		/* @var $session XenForo_Session */
		$session = XenForo_Application::get('session');
		if ($session->isRegistered('loggedInAs') || $userModel->canLoginAsUsers())
		{
			if (XenForo_Visitor::getInstance()->is_admin || XenForo_Visitor::getInstance()->is_moderator)
			{
				if ($session->isRegistered('loggedInAs'))
				{
					$viewParams['parentVisitor'] = Waindigo_LoginAsUser_Visitor::getParentInstance()->toArray();
				}
				$this->_appendTemplate('waindigo_you_are_using_as_user_loginasuser', $viewParams);
			}
		}
	}
	
	protected function _memberCardLinks()
	{
		$viewParams = $this->_fetchViewParams();

		if ($viewParams['user']['user_id'] != XenForo_Visitor::getUserId())
		{
			/* @var $userModel XenForo_Model_User */
			$userModel = XenForo_Model::create('XenForo_Model_User');
			
			if ($userModel->canLoginAsUser($viewParams['user']))
			{
				$this->_appendTemplate('waindigo_member_card_link_loginasuser');
			}
		}
	}
}