<?php

class Waindigo_LoginAsUser_Listener_TemplateCreate extends Waindigo_Listener_TemplateCreate
{
	public function run() {
		switch ($this->_templateName)
		{
			case 'PAGE_CONTAINER':
			    $this->_pageContainer();
				break;
		    case 'member_card':
			    $this->_memberCard();
			    break;
		}
		return parent::run();
	}
	
	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		$templateCreate = new Waindigo_LoginAsUser_Listener_TemplateCreate($templateName, $params, $template);
		list($templateName, $params) = $templateCreate->run();
	}
	
	protected function _pageContainer()
	{
		/* @var $session XenForo_Session */
		$session = XenForo_Application::get('session');
		if ($session->isRegistered('loggedInAs'))
		{
			if (!XenForo_Visitor::getInstance()->is_admin && !XenForo_Visitor::getInstance()->is_moderator)
			{
				$this->_params['hideLoginBar'] = true;
			}
		}
		
	    $this->_preloadTemplate('waindigo_you_are_using_as_user_loginasuser');
	    $this->_preloadTemplate('waindigo_moderator_bar_loginasuser');
	}
	
	protected function _memberCard()
	{
	    $this->_preloadTemplate('waindigo_member_card_link_loginasuser');
	}
}