<?php

/**
 * Model for users.
 *
 * @see XenForo_Model_User
 */
class Waindigo_LoginAsUser_Extend_XenForo_Model_User extends XFCP_Waindigo_LoginAsUser_Extend_XenForo_Model_User
{
    /**
     * @see XenForo_Model_User::getVisitingUserById()
     */
    public function getVisitingUserById($userId)
    {
        $userinfo = parent::getVisitingUserById($userId);

        if (!$userinfo) {
            throw new XenForo_Exception(new XenForo_Phrase('requested_user_not_found'));
        }

        return $userinfo;
    }     /* END Waindigo_LoginAsUser_Extend_XenForo_Model_User::getVisitingUserById */

	public function getUsersByUserGroupIds(array $userGroupIds, $conditions = array(), $fetchOptions = array())
	{
		$whereClause = $this->prepareUserConditions($conditions, $fetchOptions);

		$db = $this->_getDb();
		$groupConds[] = 'user.user_group_id IN (' . $db->quote($userGroupIds) . ')';
		foreach ($userGroupIds AS $groupId) {
			$groupConds[] = 'FIND_IN_SET(' . $db->quote($groupId) . ', user.secondary_group_ids)';
		}
		return $this->fetchAllKeyed('
			SELECT user.*
			FROM xf_user AS user
			WHERE ' . $whereClause . '
			    AND (' . implode(' OR ', $groupConds) . ')
		    ORDER BY username ASC
		', 'user_id');
	} /* END Waindigo_LoginAsUser_Extend_XenForo_Model_User::getUsersByUserGroupIds */

	/**
	 * Determines if the viewing user can login as the specified user.
	 *
	 * @param array $user
	 * @param string $errorPhraseKey By ref. More specific error, if available.
	 * @param array|null $viewingUser Viewing user reference
	 *
	 * @return boolean
	 */
	public function canLoginAsUser(array $user, &$errorPhraseKey = '', array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		if ($viewingUser['user_id'] && XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'loginAsDifferentUser')) {
		    if (empty($user) || !$user['user_id']) {
		        return true;
		    }

			$userGroupIds = XenForo_Application::get('options')->waindigo_loginAsUser_userGroups;

			if (is_array($userGroupIds)) {
				foreach (array_keys($userGroupIds) as $userGroupId) {
					if ($this->isMemberOfUserGroup($user, $userGroupId)) {
						return true;
					}
				}
			}
		}
		return false;
	} /* END Waindigo_LoginAsUser_Extend_XenForo_Model_User::canLoginAsUser */

	/**
	 * Determines if the viewing user can login as different users.
	 *
	 * @param string $errorPhraseKey By ref. More specific error, if available.
	 * @param array|null $viewingUser Viewing user reference
	 *
	 * @return boolean
	 */
	public function canLoginAsUsers(&$errorPhraseKey = '', array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		return ($viewingUser['user_id'] && XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'loginAsDifferentUser'));
	} /* END Waindigo_LoginAsUser_Extend_XenForo_Model_User::canLoginAsUsers */

	/**
	 * Updates the session activity of a user.
	 *
	 * @param integer $userId
	 * @param string $ip IP of visiting user
	 * @param string $controllerName Last controller class that was invoked
	 * @param string $action Last action that was invoked
	 * @param string $viewState Either "valid" or "error"
	 * @param array $inputParams List of special input params, to include to help get more info on current activity
	 * @param integer|null $viewDate The timestamp of the last page view; defaults to now
	 */
	public function updateSessionActivity($userId, $ip, $controllerName, $action, $viewState, array $inputParams, $viewDate = null)
	{
		if (!XenForo_Application::get('session')->isRegistered('loggedInAs')
			|| !XenForo_Application::get('options')->get('waindigo_loginAsUser_stealthLogin'))
		{
			parent::updateSessionActivity($userId, $ip, $controllerName, $action, $viewState, $inputParams, $viewDate);
		}
	} /* END Waindigo_LoginAsUser_Extend_XenForo_Model_User::updateSessionActivity */
}