<?php

class Waindigo_LoginAsUser_ControllerPublic_LoginAsUser extends XenForo_ControllerPublic_Abstract
{
	/**
	 * Logs in as user.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionIndex()
	{
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');

		$input = $this->_input->filter(array(
			'user_id' => XenForo_Input::UINT,
			'username' => XenForo_Input::STRING,
		));

		if ($input['username']) {
			$user = $userModel->getUserByName($input['username']);
		} else if ($input['user_id']) {
			$user = $userModel->getUserById($input['user_id']);
		} else {
		    $user = array('user_id' => '');
		}

		if (!$user) {
		    return $this->responseError(new XenForo_Phrase('requested_user_not_found'), 404);
		}
		$userId = $user['user_id'];

		if (XenForo_Application::isRegistered('session')) {
			/* @var $session XenForo_Session */
			$session = XenForo_Application::get('session');
			if (!$session->isRegistered('loggedInAs') || $session->get('loggedInAs') != $userId) {
				if (Waindigo_LoginAsUser_Visitor::getParentInstance()->user_id != $userId) {
					if ($userModel->canLoginAsUser($user)) {
						$session->regenerate(true);
						$session->set('loggedInAs', $userId);
						$session->save();
					} else {
						return $this->responseNoPermission();
					}
				} else if ($session->isRegistered('loggedInAs')) {
					$session->regenerate(true);
					$session->remove('loggedInAs');
					$session->save();
				}
			}
		}

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
	        $this->getDynamicRedirect(XenForo_Link::buildPublicLink('index')),
	        new XenForo_Phrase('waindigo_login_successful_loginasuser')
		);
	} /* END Waindigo_LoginAsUser_ControllerPublic_LoginAsUser::actionIndex */

	/**
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionChoice()
	{
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');

		$users = array();

		$xenOptions = XenForo_Application::get('options');

		if (!$xenOptions->waindigo_loginAsUser_useComboBox) {
			if ($userModel->canLoginAsUsers()) {
				$userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_loginAsUser_userGroups);

				if (!empty($userGroupIds)) {
					$users = $userModel->getUsersByUserGroupIds($userGroupIds);
					unset($users[XenForo_Visitor::getUserId()]);
				}
			}
		}

		$viewParams = array(
		    'redirect' => $this->getDynamicRedirect(),
	        'useAutoCombo' => Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled('Waindigo_AutoCombo', 'load_class_controller'),
			'users' => $users,
		);

		return $this->responseView('Waindigo_LoginAsUser_View_LoginAsUser_Choice', 'waindigo_login_as_user_loginasuser', $viewParams);
	} /* END Waindigo_LoginAsUser_ControllerPublic_LoginAsUser::actionChoice */

	public function actionFindAutoCombo()
	{
		$q = $this->_input->filterSingle('q', XenForo_Input::STRING);

		$users = array();
		if ($this->_getUserModel()->canLoginAsUsers()) {
			$userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_loginAsUser_userGroups);

			if (!empty($userGroupIds)) {
				$conditions = array();
				if ($q) $conditions['username'] = array($q , 'r');
				$users = $this->_getUserModel()->getUsersByUserGroupIds($userGroupIds, $conditions);
				unset($users[XenForo_Visitor::getUserId()]);
			}
		}

		$viewParams = array(
			'users' => $users
		);

		return $this->responseView(
			'XenForo_ViewPublic_Member_Find',
			'member_autocomplete',
			$viewParams
		);
	} /* END Waindigo_LoginAsUser_ControllerPublic_LoginAsUser::actionFindAutoCombo */

	public function actionFind()
	{
		$q = $this->_input->filterSingle('q', XenForo_Input::STRING);

		$users = array();
		if ($this->_getUserModel()->canLoginAsUsers()) {
			$userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_loginAsUser_userGroups);

			if (!empty($userGroupIds) && $q !== '' && utf8_strlen($q) >= 2) {
				$conditions['username'] = array($q , 'r');
				$users = $this->_getUserModel()->getUsersByUserGroupIds($userGroupIds, $conditions);
				unset($users[XenForo_Visitor::getUserId()]);
			}
		}

		$viewParams = array(
			'users' => $users
		);

		return $this->responseView(
			'XenForo_ViewPublic_Member_Find',
			'member_autocomplete',
			$viewParams
		);
	} /* END Waindigo_LoginAsUser_ControllerPublic_LoginAsUser::actionFind */

	protected function _assertBoardActive($action) {
	    // do nothing
	} /* END Waindigo_LoginAsUser_ControllerPublic_LoginAsUser::assertBoardActive */

	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	} /* END Waindigo_LoginAsUser_ControllerPublic_LoginAsUser::_getUserModel */
}