<?php

class Waindigo_Listener_LoadClass
{
    protected $_class = null;
    protected $_extend = null;

    /**
     * @param string $class
     * @param array $extend
     */
    public function __construct(&$class = '', array &$extend = array())
    {
        $this->_class = $class;
        $this->_extend = $extend;
    } /* END Waindigo_Listener_LoadClass::__construct */

    /**
     * Called when instantiating any class. This event can be used to extend
     * the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClass($class, array &$extend)
    {
        // This only works on PHP 5.3+, so method should be overridden for now
        $className = get_called_class();
        $loadClass = new $className($class, $extend);
        $extend = $loadClass->run();
    }

    /**
     * Called when instantiating a BB code formatter. This event can be used to
     * extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassBBCode($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassBBCode */

    /**
     * Called when instantiating a controller. This event can be used to extend
     * the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassController($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassController */

    /**
     * Called when instantiating a data writer. This event can be used to
     * extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassDataWriter($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassDataWriter */

    /**
     * Called when instantiating an image processor. This event can be used to
     * extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassImage($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassImage */

    /**
     * Called when instantiating an importer. This event can be used to extend
     * the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassImporter($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassImporter */

    /**
     * Called when instantiating an installer. This event can be used to extend
     * the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassInstallerWaindigo($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassInstallerWaindigo */

    /**
     * Called when instantiating a mail object. This event can be used to
     * extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassMail($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassMail */

    /**
     * Called when instantiating a model. This event can be used to extend the
     * class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassModel($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassModel */

    /**
     * Called when instantiating a PDF. This event can be used to extend the
     * class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassPdfWaindigo($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassPdfWaindigo */

    /**
     * Called when instantiating a PHP file. This event can be used to extend
     * the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassPhpFileWaindigo($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassPhpFileWaindigo */

    /**
     * Called when instantiating a reward handler. This event can be used to
     * extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassRewardHandler($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassRewardHandler */

    /**
     * Called when instantiating a specific route prefix class. This event can
     * be used to extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassRoutePrefix($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassRoutePrefix */

    /**
     * Called when instantiating a search data handler. This event can be used
     * to extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassSearchData($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassSearchData */

    /**
     * Called when instantiating a search source. This event can be used to
     * extend the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassSearchSource($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassSearchSource */

    /**
     * Called when instantiating a template. This event can be used to extend
     * the class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassTemplateWaindigo($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassTemplateWaindigo */

    /**
     * Called when instantiating a view. This event can be used to extend the
     * class that will be instantiated dynamically.
     *
     * @param string $class - the name of the class to be created
     * @param array &$extend - a modifiable list of classes that wish to extend the class.
     */
    public static function loadClassView($class, array &$extend)
    {
        self::loadClass($class, $extend);
    } /* END Waindigo_Listener_InitDependencies::loadClassView */

    /**
     * @return array $extend
     */
    public function run()
    {
        $extends = $this->_getExtends();

        if (!empty($extends)) {
            foreach ($extends as $class => $extend) {
                if ($class == $this->_class && !empty($extend)) {
                    if (is_array($extend)) {
                        foreach ($extend as $extendClass) {
                            if (!in_array($extendClass, $this->_extend)) {
                                $this->_extend[] = $extendClass;
                            }
                        }
                    } else {
                        if (!in_array($extend, $this->_extend)) {
                            $this->_extend[] = $extend;
                        }
                    }
                }
            }
        }
        return $this->_extend;
    } /* END Waindigo_Listener_LoadClass::run */

    /**
     * @return array $extend
     */
    protected function _run()
    {
        try {
            return $this->run();
        } catch (Exception $e) {
            return $this->_extend;
        }
    } /* END Waindigo_Listener_LoadClass::_run */

    /**
     * @return array $extend
     */
    protected function _getExtends(){
        return array();
    } /* END Waindigo_Listener_LoadClass::_getExtends */

    /**
     * @return array
     */
    public function getExtendedClasses()
    {
        return array_keys($this->_getExtends());
    } /* END Waindigo_Listener_LoadClass::getExtendedClasses */

    /**
     * Gets the specified model object from the cache. If it does not exist,
     * it will be instantiated.
     *
     * @param string $class Name of the class to load
     *
     * @return XenForo_Model
     */
    public function getModelFromCache($class)
    {
        if (!isset($this->_modelCache[$class])) {
            $this->_modelCache[$class] = XenForo_Model::create($class);
        }

        return $this->_modelCache[$class];
    } /* END Waindigo_Listener_LoadClass::getModelFromCache */

    /**
     * Factory method to get the named load class code event listener.
     * The class must exist or be autoloadable or an exception will be thrown.
     *
     * @param string Class to load
     *
     * @return Waindigo_Listener_LoadClass
     */
    public static function create($class)
    {
        $createClass = XenForo_Application::resolveDynamicClass($class, 'waindigo_load_class');
        if (!$createClass)
        {
            throw new XenForo_Exception("Invalid code event listener '$class' specified");
        }

        return new $createClass;
    }

    /**
     * Deprecated.
     *
     * @param $class
     * @param $extend
     * @deprecated
     **/
    protected static function _extend($class, array &$extend)
    {
        if (!in_array($class, $extend)) {
            $extend[] = $class;
        }
    } /* END Waindigo_Listener_LoadClass::_extend */
}