<?php

class Waindigo_Listener_LoadClass
{
	protected $_class = null;
	protected $_extend = null;
	
	/**
	 * @param string $class
	 * @param array $extend
	 */
	public function __construct(&$class, array &$extend)
	{
		$this->_class = $class;
		$this->_extend = $extend;
	}
	
	/**
	 * @return array
	 */
	public function run()
	{
		$extends = $this->_getExtends();
		
		foreach ($extends as $class => $extend)
		{
			if ($class == $this->_class && !empty($extend))
			{
				if (is_array($extend))
				{
					foreach ($extend as $extendClass)
					{
						$this->_extend[] = $extendClass;
					}
				}
				else
				{
					$this->_extend[] = $extend;
				}
			}
		}
		
		return $this->_extend;
	}
	
	/**
	 * @return array
	 */
	protected function _run()
	{
		try {
			return $this->run();
		} catch (Exception $e) {
			return $this->_extend;
		}
	}
	
	/**
	 * @return array
	 */
	protected function _getExtends(){}
	
	/**
	 * Gets the specified model object from the cache. If it does not exist,
	 * it will be instantiated.
	 *
	 * @param string $class Name of the class to load
	 *
	 * @return XenForo_Model
	 */
	public function getModelFromCache($class)
	{
		if (!isset($this->_modelCache[$class]))
		{
			$this->_modelCache[$class] = XenForo_Model::create($class);
		}
	
		return $this->_modelCache[$class];
	}
	
	/**
	 * Deprecated.
	 * 
	 * @param $class
	 * @param $extend
	 * @deprecated
	 **/
	protected static function _extend($class, array &$extend)
	{
		if (!in_array($class, $extend))
		{
			$extend[] = $class;
		}
	}
}