<?php

class Waindigo_Friends_Listener_TemplatePostRender extends Waindigo_Listener_TemplatePostRender
{
	public function run() {
		switch ($this->_templateName)
		{
			case 'member_view':
				$this->_memberView();
				break;
			case 'member_card':
				$this->_memberView(false);
				break;
		}
		return parent::run();
	}

	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		$templatePostRender = new Waindigo_Friends_Listener_TemplatePostRender($templateName, $content, $containerData, $template);
		list($content, $containerData) = $templatePostRender->run();
	}

	protected function _memberView($li = true)
	{
		$viewParams = $this->_fetchViewParams();
		$viewParams['_noLi'] = !$li;
		$options = XenForo_Application::getOptions();
		$pattern = array(
				'/(' . ($li ? '<li>' : ''). '<a(.*?)>'. new XenForo_Phrase('unfollow').'<\/a>' . ($li ? '<\/li>' : ''). ')/',
				'/(' . ($li ? '<li>' : ''). '<a(.*?)>'. new XenForo_Phrase('follow').'<\/a>' . ($li ? '<\/li>' : ''). ')/',
				'/(<div class="followBlocks">)/'
		);
		$replacement = array('$1','$1','$1');
		if (isset($viewParams['friend_record']['friend_state']) && $viewParams['friend_record']['friend_state'] != 'rejected')
		{
			if ($viewParams['friend_record']['friend_state'] == 'confirmed')
			{
				$replacement[0] = $this->_render('waindigo_member_view_unfriend_link_friend', $viewParams).'$1';
				$replacement[1] = $replacement[0];
			}
			else if ($viewParams['friend_record']['friend_state'] == 'pending')
			{
				if ($viewParams['friend_record']['user_id'] == XenForo_Visitor::getUserId() && $li)
				{
					$replacement[0] = $this->_render('waindigo_member_view_friend_request_pending_friend').'$1';
					$replacement[1] = $replacement[0];
				}
				else
				{
					$replacement[0] = $this->_render('waindigo_member_view_confirm_link_friend', $viewParams).'$1';
					if (!$options->waindigo_friends_requireFollow)
					{
						$replacement[1] = $replacement[0];
					}
				}
			}
		}
		else
		{
			$replacement[0] = $this->_render('waindigo_member_view_friend_link_friend', $viewParams).'$1';
			if (!$options->waindigo_friends_requireFollow)
			{
				$replacement[1] = $replacement[0];
			}
		}
		$replacement[2] = '$1'.$this->_render('waindigo_member_view_friend_blocks_friend');
		$this->_contents = preg_replace($pattern, $replacement, $this->_contents);
	}
}