<?php

/**
 * Model for idle user emails.
 */
class Waindigo_EmailIdleUsers_Model_EmailIdleUsers extends XenForo_Model
{

    public function getIdleUsersByUserId($userId)
    {
        return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_idle_user
			WHERE user_id = ?
			LIMIT 1
		', $userId);
    } /* END getIdleUsersByUserId */

    public function fetchIdleUsersForEmailOne($maxEmailsPerDay, $cutOffDateOne)
    {
        return $this->fetchAllKeyed(
            "
			SELECT user.*
			FROM xf_user AS user
			LEFT JOIN xf_idle_user AS idle_user ON
				(idle_user.user_id = user.user_id)
            LEFT JOIN xf_user_option AS user_option ON
                (user_option.user_id = user.user_id)
			WHERE user.user_state = 'valid'
                AND user.is_banned != 1
                AND user_option.is_discouraged != 1
                AND idle_user.email_one_date IS NULL
                AND (user.last_activity < $cutOffDateOne)
                AND user.email <> ''
			LIMIT ?
		", 'user_id', $maxEmailsPerDay);
    } /* END fetchIdleUsersForEmailOne */

    public function fetchIdleUsersForEmailTwo($maxEmailsPerDay, $cutOffDateTwo)
    {
        $options = XenForo_Application::get('options');

        // only if x days have passed since first email - prevents both emails
        // being sent out at once
        $daysdDifference = $options->waindigo_emailIdleUsers_num_days_email_two - $options->waindigo_emailIdleUsers_num_days_email_one;

        return $this->fetchAllKeyed(
            "
			SELECT user.*
			FROM xf_user AS user
			LEFT JOIN xf_idle_user AS idle_user ON
					(idle_user.user_id = user.user_id)
			WHERE user.user_state = 'valid'
                AND (idle_user.email_one_date IS NOT NULL
                AND idle_user.email_two_date IS NULL)
                AND (user.last_activity < $cutOffDateTwo)
                AND (? - idle_user.email_one_date > (? * 86400))
                AND user.email <> ''
			LIMIT ?
		", 'user_id',
            array(
                XenForo_Application::$time,
                $daysdDifference,
                $maxEmailsPerDay
            ));
    } /* END fetchIdleUsersForEmailTwo */

    public function registerEmailOne($userId)
    {
        $this->_getDb()->query(
            '
					INSERT INTO xf_idle_user
						(user_id, email_one_date)
					VALUES
						(?, ?)
					ON DUPLICATE KEY UPDATE
						email_one_date = ' . XenForo_Application::$time . '
				', array(
                $userId,
                XenForo_Application::$time
            ));
    } /* END registerEmailOne */

    public function registerEmailTwo($userId)
    {
        $this->_getDb()->update('xf_idle_user',
            array(
                'user_id' => $userId,
                'email_two_date' => XenForo_Application::$time
            ), 'user_id = ' . $this->_getDb()
                ->quote($userId));
    } /* END registerEmailTwo */

    public function removeIdleUser($userId)
    {
        $db = $this->_getDb();
        $db->delete('xf_idle_user', 'user_id = ' . $db->quote($userId));
    } /* END removeIdleUser */
}