<?php

class Waindigo_EmailIdleUsers_Install_Controller extends Waindigo_Install
{

    protected $_resourceManagerUrl = 'http://xenforo.com/community/resources/email-idle-users-by-waindigo.2039/';

    protected $_minVersionId = 1010170;

    protected $_minVersionString = '1.1.1';

    /**
     *
     * @see Waindigo_Install::_getTables()
     */
    protected function _getTables()
    {
        return array(
            'xf_idle_user' => array(
                'user_id' => 'int(10) UNSIGNED NOT NULL PRIMARY KEY', /* 'user_id' */
                'email_one_date' => 'int(10) unsigned NOT NULL', /* 'email_one_date' */
                'email_two_date' => 'int(10) unsigned NULL', /* 'email_two_date' */
            ), /* 'xf_idle_user' */
            'xf_idle_user_log' => array(
                'log_id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY', /* 'log_id' */
                'log_date' => 'int(10) unsigned NOT NULL', /* 'log_date' */
                'user_id' => 'int(10) NOT NULL', /* 'user_id' */
                'username' => 'VARCHAR(50) NOT NULL', /* 'username' */
                'content_type' => 'VARCHAR(25) NOT NULL', /* 'content_type' */
                'action' => 'VARCHAR(25) NOT NULL', /* 'action' */
                'action_params' => 'MEDIUMBLOB NOT NULL', /* 'action_params' */
            ), /* 'xf_idle_user_log' */
        );
    } /* END _getTables */

    /**
     *
     * @see Waindigo_Install::_getKeys()
     */
    protected function _getKeys()
    {
        return array(
            'xf_idle_user_log' => array(
                'log_date' => array(
                    'log_date'
                ), /* END 'log_date' */
                'user_id_content_type' => array(
                    'user_id',
                    'content_type'
                ), /* END 'user_id_content_type' */
                'user_id_log_date' => array(
                    'user_id',
                    'log_date'
                ), /* END 'user_id_log_date' */
            ) /* END 'xf_idle_user_log' */
        );
    } /* END _getKeys */

    protected function _getContentTypeFields()
    {
        return array(
            'user' => array(
                'email_idle_users_log_handler_class' => 'Waindigo_EmailIdleUsers_EmailIdleUsersLogHandler_User', /* END 'email_Idle_users_log_handler_class' */
            ), /* END 'user' */
        );
    } /* END _getContentTypeFields */
}