<?php

/**
 *
 * @see XenForo_Model_User
 */
class Waindigo_EmailIdleUsers_Extend_XenForo_Model_User extends XFCP_Waindigo_EmailIdleUsers_Extend_XenForo_Model_User
{

    /**
     *
     * @see XenForo_Model_User::validateAuthentication()
     */
    public function validateAuthentication($nameOrEmail, $password, &$error = '')
    {
        $response = parent::validateAuthentication($nameOrEmail, $password, $error);

        if ($response) {
            $emailIdleUsersModel = $this->_getEmailIdleUsersModel();
            $emailIdleUsersModel->removeIdleUser($response);
        }

        return $response;
    } /* END validateAuthentication */

    /**
     *
     * @return Waindigo_EmailIdleUsers_Model_EmailIdleUsers
     */
    protected function _getEmailIdleUsersModel()
    {
        return $this->getModelFromCache('Waindigo_EmailIdleUsers_Model_EmailIdleUsers');
    } /* END _getEmailIdleUsersModel */
}