<?php

/**
 * Cron entry for sending out emails to emailIdleUsers members.
 *
 * @package EmailIdleUsers
 */
class Waindigo_EmailIdleUsers_CronEntry_Email
{

    /**
     * Send out emails to emailIdleUsers members
     */
    public static function sendEmails()
    {
        $options = XenForo_Application::get('options');
        $numDaysEmailOne = $options->waindigo_emailIdleUsers_num_days_email_one;
        $numDaysEmailTwo = $options->waindigo_emailIdleUsers_num_days_email_two;
        $maxEmailsPerDay = $options->waindigo_emailIdleUsers_max_emails_per_day;

        $emailSubjectOne = $options->waindigo_emailIdleUsers_email_subject_one;
        $emailSubjectTwo = $options->waindigo_emailIdleUsers_email_subject_two;

        $emailBodyOneText = $options->waindigo_emailIdleUsers_email_text_one;
        $emailBodyTwoText = $options->waindigo_emailIdleUsers_email_text_two;
        $emailBodyOneHTML = $options->waindigo_emailIdleUsers_email_html_one;
        $emailBodyTwoHTML = $options->waindigo_emailIdleUsers_email_html_two;

        $cutOffDateOne = XenForo_Application::$time - $numDaysEmailOne * 86400;
        $cutOffDateTwo = XenForo_Application::$time - $numDaysEmailTwo * 86400;
        $emailIdleUsersModel = XenForo_Model::create('Waindigo_EmailIdleUsers_Model_EmailIdleUsers');
        $emailIdleUsersLogModel = XenForo_Model::create('Waindigo_EmailIdleUsers_Model_EmailIdleUsersLog');
        $excludeUserNames = explode(',', $options->waindigo_emailIdleUsers_email_username_exclude);
        $template = 'waindigo_email_emailidleusers';

        // fetch Idle members that meet criteria for email one
        $users = $emailIdleUsersModel->fetchIdleUsersForEmailOne($maxEmailsPerDay, $cutOffDateOne);

        if (!empty($users) && !empty($excludeUserNames)) {
            $excludeArray = array();
            foreach ($users as $user) {
                $username = strtolower(trim($user['username']));
                foreach ($excludeUserNames as $excludeName) {
                    $excludeName = strtolower(trim($excludeName));
                    if ($username == $excludeName) {
                        $excludeArray[$user['user_id']] = $username;
                    }
                }
            }

            $users = array_diff_key($users, $excludeArray);
        }

        // send email one
        foreach ($users as $user) {
            if (!empty($user['email'])) {
                $params = array(
                    'boardTitle' => $options->boardTitle,
                    'boardUrl' => $options->boardUrl,
                    'subject' => $emailSubjectOne,
                    'plainText' => $emailBodyOneText,
                    'htmlText' => $emailBodyOneHTML
                );

                $params['username'] = $user['username'];
                $params['plainText'] = strtr($params['plainText'],
                    array(
                        '{username}' => $user['username'],
                        '{numDays}' => $numDaysEmailOne,
                        '{boardUrl}' => $params['boardUrl'],
                        '{boardTitle}' => $params['boardTitle']
                    ));
                $params['htmlText'] = nl2br(
                    strtr($params['htmlText'],
                        array(
                            '{username}' => $user['username'],
                            '{numDays}' => $numDaysEmailOne,
                            '{boardUrl}' => $params['boardUrl'],
                            '{boardTitle}' => $params['boardTitle']
                        )));

                $mail = XenForo_Mail::create($template, $params, $user['language_id']);
                $mail->enableAllLanguagePreCache();
                $mail->queue($user['email'], $user['username']);

                // insert into table
                $emailIdleUsersModel->registerEmailOne($user['user_id']);

                // log entry
                $actionParams['old'] = $user['last_activity'];
                $emailIdleUsersLogModel->logIdleUsersAction('user', 'email_one', $actionParams, $user);
            }
        }

        // fetch emailIdleUsers members that meet criteria for email two
        $maxEmailsPerDay = $maxEmailsPerDay - count($users);
        if ($maxEmailsPerDay > 0) {
            $users = $emailIdleUsersModel->fetchIdleUsersForEmailTwo($maxEmailsPerDay, $cutOffDateTwo);

            if (!empty($users) && !empty($excludeUserNames)) {
                $excludeArray = array();
                foreach ($users as $user) {
                    $username = strtolower(trim($user['username']));
                    foreach ($excludeUserNames as $excludeName) {
                        $excludeName = strtolower(trim($excludeName));
                        if ($username == $excludeName) {
                            $excludeArray[$user['user_id']] = $username;
                        }
                    }
                }

                $users = array_diff_key($users, $excludeArray);
            }

            // send email two
            foreach ($users as $user) {
                if (!empty($user['email'])) {
                    $params = array(
                        'boardTitle' => $options->boardTitle,
                        'boardUrl' => $options->boardUrl,
                        'subject' => $emailSubjectTwo,
                        'plainText' => $emailBodyTwoText,
                        'htmlText' => $emailBodyTwoHTML
                    );

                    $params['username'] = $user['username'];
                    $params['plainText'] = strtr($params['plainText'],
                        array(
                            '{username}' => $user['username'],
                            '{boardUrl}' => $params['boardUrl'],
                            '{boardTitle}' => $params['boardTitle']
                        ));
                    $params['htmlText'] = nl2br(
                        strtr($params['htmlText'],
                            array(
                                '{username}' => $user['username'],
                                '{boardUrl}' => $params['boardUrl'],
                                '{boardTitle}' => $params['boardTitle']
                            )));

                    $mail = XenForo_Mail::create($template, $params, $user['language_id']);
                    $mail->enableAllLanguagePreCache();
                    $mail->queue($user['email'], $user['username']);

                    // insert into table
                    $emailIdleUsersModel->registerEmailTwo($user['user_id']);

                    // log entry
                    $actionParams['old'] = $user['last_activity'];
                    $emailIdleUsersLogModel->logIdleUsersAction('user', 'email_two', $actionParams, $user);
                }
            }
        }
    } /* END sendEmails */
}