<?php
class SplendidNetwork_XfRuAlbumsMore_Model_Albums extends XFCP_SplendidNetwork_XfRuAlbumsMore_Model_Albums
{
	protected function prepareFetchOptions(array $fetchOptions)
	{
		$options = parent::prepareFetchOptions($fetchOptions);
		
		$find = "'public'";		
		$append = " OR album.album_type = 'members' OR album.album_type = 'followed' OR album.album_type = 'selected'";		
		$options['conditions'] = str_replace($find, $find . $append, $options['conditions']);
		
		return $options;
	}
	
	
	public function getUserLatestAlbumId($userId)
	{
		return $this->_getDb()->fetchOne('
				SELECT MAX(album.album_id) AS album_id
				FROM xfr_useralbum AS album
				WHERE album.user_id = ' . $userId .'
				');
	}

	public function updateAlbumSelectedUsers($albumId, $userIds)
	{
		$db = $this->_getDb();
		
		return $db->query('UPDATE xfr_useralbum SET selected_users = "' . $userIds . '" WHERE album_id = ?', $albumId);
	}
	
	public function getAlbums($fetchOptions = array())
	{
		$response = parent::getAlbums($fetchOptions);
		
		if($response)
			$response = $this->limitAlbumsOnType($response);
		
		return $response;
	}
	
	public function getUserAlbums($userId, $fetchOptions = array())
	{
		return $this->limitAlbumsOnType(parent::getUserAlbums($userId, $fetchOptions));
	}
	
	public function assertAlbumValidAndViewable($albumId, $albumHash = null)
	{
		try 
		{
			$album = parent::assertAlbumValidAndViewable($albumId, $albumHash);
		} 
		catch (Exception $e) 
		{
			throw XenForo_Controller::getNoPermissionResponseException();
		}
		
		list($album) = $this->limitAlbumsOnType(array($album));
		return $album;
	}
	
	public function limitAlbumsOnType($albums)
	{
		if($albums)
		{
			$visitor = XenForo_Visitor::getInstance();
	
			foreach($albums AS $key => $album)
			{
				if(!$visitor['user_id'])
				{
					if($album['album_type'] == 'members' || $album['album_type'] == 'followed' || $album['album_type'] == 'selected')
					{
						unset($albums[$key]);
					}
				}
				else
				{
					if($album['user_id'] == $visitor['user_id'])
						continue;
	
					if($visitor->hasPermission('xfrUserAlbumsPermissions', 'xfr_UAM_ByPassPrivacy'))
						continue;
	
					if($album['album_type'] == 'followed')
					{
						$userModel = $this->_getUserModel();
	
						$followRecord = $userModel->getFollowRecord($album['user_id'], $visitor['user_id']);
						if(!$followRecord)
						{
							unset($albums[$key]);
						}
					}
	
					if($album['album_type'] == 'selected')
					{
						$selected_users = explode(',',$album['selected_users']);
	
						if (!in_array($visitor['user_id'], $selected_users))
						{
							unset($albums[$key]);
						}
					}
				}
			}
		}
		return $albums;
	}
	
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
}