<?php

class RouteChanger_Route_Prefix_11 extends XFCP_RouteChanger_Route_Prefix_11
{
	public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
	{
		$key = 11;
		$newRoute =& RouteChanger_Route_Static::$newRoute[$key];

		$outputPrefix = $newRoute['prefix'];
		$usingAlt = false;
		if ($outputPrefix == $originalPrefix)
		{
			if ($newRoute['altprefix'])
			{
				$outputPrefix = $newRoute['altprefix'];
				$usingAlt = true;
			}

		}
		$class = ($usingAlt ? $newRoute['class'] : $newRoute['origclass']);
		$buildLink = ($usingAlt ? $newRoute['build_link'] : $newRoute['orig_build_link']);

		$retval = false;
		if (method_exists($class, 'buildLink') AND (   $buildLink == 'all'
			OR ($buildLink == 'data_only' AND (boolean)$data)   )
		)
		{
			if ($usingAlt)
			{
				$handler = new $class;
				$retval = $handler->buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, $extraParams);
			}
			else
			{
				$retval = parent::buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, $extraParams);
			}
		}

		if (!$retval)
		{
			$retval = XenForo_Link::buildBasicLink($outputPrefix, $action, $extension);
		}

		return $retval;
	}
}