<?php

class ProfileViewCount_Listener
{
        public static function extendMemberController($class, array &$extend)
        {                
                switch ($class)
                {
					case 'XenForo_ControllerPublic_Member':
					
						$extend[] = 'ProfileViewCount_ControllerPublic_Member';
						break;
						
					case 'XenForo_ControllerAdmin_User':
					
						$extend[] = 'ProfileViewCount_ControllerAdmin_User';
						break;
                }
        }
        
        public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
        {
				$template->preloadTemplate('profile_view_count');
        }
        
        public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
        { 		
                switch ($hookName)
                {                	
                        case 'member_view_sidebar_' . XenForo_Application::get('options')->profileViewMemberBlockPosition:

                                $params = $template->getParams();
                                $params += $hookParams;
                                $contents .= $template->create('profile_view_count', $params);
                                break;
                        
                        case  'page_container_sidebar':
                                
                                $hookParams['mostViewed'] = XenForo_Model::create('XenForo_Model_DataRegistry')->get('mostViewed');
                                
                                $params = $template->getParams();
                                $params += $hookParams;
                                
                                // Find the below string in $contents and split at that point to insert template at desired position
                                
                                $string = '<<!-- block: forum_stats -->>';
                                
                                $split = preg_split($string, $contents);
                                
                                $contents = $split['0'] . $template->create('profile_view_most_viewed', $params) . $split['1'];
                                break;
                                
                }
        }
}