<?php
  
class ProfileViewCount_ControllerAdmin_User extends XFCP_ProfileViewCount_ControllerAdmin_User
{
	public function actionProfileViews()
	{
		$criteria = $this->_input->filterSingle('criteria', XenForo_Input::ARRAY_SIMPLE);
		$criteria = $this->_filterUserSearchCriteria($criteria);
				
		$profileViewModel = $this->_getProfileViewModel();
		
		$filter = $this->_input->filterSingle('_filter', XenForo_Input::ARRAY_SIMPLE);
		if ($filter && isset($filter['value']))
		{
			$criteria['username2'] = array($filter['value'], empty($filter['prefix']) ? 'lr' : 'r');
			$filterView = true;
		}
		else
		{
			$filterView = false;
		}
		
		$order = $this->_input->filterSingle('order', XenForo_Input::STRING);
		$direction = $this->_input->filterSingle('direction', XenForo_Input::STRING);		
		
		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$usersPerPage = 20;
		
		$fetchOptions = array(
			'perPage' => $usersPerPage,
			'page' => $page,
			
			'join' => XenForo_Model_User::FETCH_USER_PROFILE,

			'order' => $order,
			'direction' => $direction
		);
		
		$criteriaPrepared = $this->_prepareUserSearchCriteria($criteria);
		
		$userModel = XenForo_Model::create('XenForo_Model_User');
		
		//Make use of the User Model function.
		$totalUsers = $userModel->countUsers($criteriaPrepared);
		
		if (!$totalUsers)
		{
			return $this->responseError(new XenForo_Phrase('no_users_matched_specified_criteria'));
		}		
		
		$users = $profileViewModel->getUsers($criteriaPrepared, $fetchOptions);
		
		$viewParams = array(
			'users' => $users,
			'totalUsers' => $totalUsers,
			
			'usersPerPage' => $usersPerPage,
			
			'page' => $page,
			
			'filterView' => $filterView,
			'filterMore' => ($filterView && $totalUsers > $usersPerPage)
		);		
		
		return $this->responseView('ProfileViewCount_ViewAdmin_User_List', 'profile_views_user_list', $viewParams);		
	}
	
	public function actionResetViews()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		
		if ($userId)
		{
	        if ($this->isConfirmedPost())
	        {
				$this->_getProfileViewModel()->resetProfileViews($userId);

				$redirectLink = XenForo_Link::buildAdminLink('users/profile-views');
				$redirectMessage = new XenForo_Phrase('reset_successful');

				return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, $redirectLink, $redirectMessage);
	        }
	        else
	        {
	            $viewParams = array('user' => $this->_getProfileViewModel()->getUserProfileViews($userId));

	            return $this->responseView('ProfileViewCount_ViewAdmin_Reset', 'profile_views_user_reset', $viewParams);				
	        }
		}
		else
		{
	        if ($this->isConfirmedPost())
	        {
				$this->_getProfileViewModel()->resetProfileViews($userId);

				$redirectLink = XenForo_Link::buildAdminLink('users/profile-views');
				$redirectMessage = new XenForo_Phrase('reset_successful');

				return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, $redirectLink, $redirectMessage);
	        }
	        else
	        {
	            $viewParams = array();

	            return $this->responseView('ProfileViewCount_ViewAdmin_Reset', 'profile_views_user_reset', $viewParams);				
	        }			
		}
	}
	
	protected function _getProfileViewModel()
	{
		return $this->getModelFromCache('ProfileViewCount_Model_ViewCount');
	}       	
}