<?php

class NewUserConversation_Option
{
	public static $templateOptionName = 'newuserconversation_option';

	public static function render(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$editLink = $view->createTemplateObject('option_list_option_editlink', array(
			'preparedOption' => $preparedOption,
			'canEditOptionDefinition' => $canEdit
		));

		$return = '';

		if ($preparedOption['option_value'] != '') {

			$usersAsArray = explode(',', $preparedOption['option_value']);
			$users = XenForo_Model::create('XenForo_Model_User')->getUsersByIds($usersAsArray);
			foreach ($users AS $userId => $userData) {
				$return .= $userData['username'] . ', ';
			}
			$preparedOption['option_value'] = $return;
		}

		return $view->createTemplateObject(self::$templateOptionName, array(
			'fieldPrefix' => $fieldPrefix,
			'listedFieldName' => $fieldPrefix . '_listed[]',
			'preparedOption' => $preparedOption,
			'formatParams' => $preparedOption['formatParams'],
			'editLink' => $editLink,
		));
	}


	public static function verifyOption(&$usersInput, XenForo_DataWriter $dw, $fieldName)
	{
		if ($dw->isInsert()) {
			return true;
		}

		$usersArray = explode(',', $usersInput);
		$userModel = XenForo_Model::create('XenForo_Model_User');
		$usersArray = $userModel->getUsersByNames($usersArray);

		$users = '';
		foreach ($usersArray as $userID => $userData) {
			$users .= $userID . ',';
		}
		$usersInput = $users;
		return true;
	}
}