<?php

class NewUserConversation_Extend_DataWriter_User extends
	#XenForo_DataWriter_User
	XFCP_NewUserConversation_Extend_DataWriter_User
{
	protected function _postSave()
	{
		parent::_postSave();
		if ($this->isInsert() && !$this->getOption(self::OPTION_ADMIN_EDIT)) {
			$this->sendWelcomeConversation();
		}
	}


	protected function sendWelcomeConversation(){
		$userData = $this->getMergedData();
		$options = XenForo_Application::getOptions();

		$usersArray = explode(',', $options->get('newuserconversation_creator'));

		$sender = array_rand($usersArray);
		$sender = XenForo_Model::create('XenForo_Model_User')->getUserById($usersArray[$sender]);

		while (! $sender) {
			$sender = array_rand($usersArray);
			$sender = XenForo_Model::create('XenForo_Model_User')->getUserById($usersArray[$sender]);
		}

		if ($sender) {

			$closeConversation = XenForo_Application::getOptions()->newuserconversation_close;

			$phrasePrams = array(
				'boardname' => $options->boardTitle,
				'homeUrl' => ($options->homePageUrl ? $options->homePageUrl : XenForo_Link::buildPublicLink('full:index')),
				'eMail' => $userData['email'],
				'username' => $userData['username'],
				'profileurl' => XenForo_Link::buildPublicLink('full:members', $userData)
			);

			$title = new XenForo_Phrase('newuserconversation_title', $phrasePrams);
			$message = new XenForo_Phrase('newuserconversation_message', $phrasePrams);

			$conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');

			$conversationDw->set('user_id', $sender['user_id']);
			$conversationDw->set('username', $sender['username']);
			$conversationDw->set('title', $title);

			$conversationDw->set('open_invite', 0);

			if ($closeConversation) {
				$conversationDw->set('conversation_open', 0);
			}

			$conversationDw->addRecipientUserIds(array($userData['user_id']));
			$messageDw = $conversationDw->getFirstMessageDw();

			$messageDw->setOption(XenForo_DataWriter_ConversationMessage::OPTION_SET_IP_ADDRESS, false);

			$messageDw->set('message', $message);

			$conversationDw->preSave();
			$conversationDw->save();
			$conversation = $conversationDw->getMergedData();
			/** @var $convModel XenForo_Model_Conversation */
			$convModel = XenForo_Model::create('XenForo_Model_Conversation');

			$convModel->markConversationAsRead(
				$conversation['conversation_id'], $sender['user_id'], XenForo_Application::$time
			);

			if ($options->newuserconversation_leave){
				if ($closeConversation){
					$deleteType = 'delete_ignore';
				}else {
					$deleteType = 'delete';
				}

				$convModel->deleteConversationForUser(
					$conversation['conversation_id'],$sender['user_id'], $deleteType
				);
			}
		}
	}

}