<?php

class EWRporta_Block_UserAlbumsLatestPictures extends XenForo_Model
{
const THUMBS_PATH = '/data/xfru/useralbums/thumbnails/';
public static $dataColumns =
		'`data`.filename, `data`.description, `data`.file_size, `data`.file_hash, data.width, data.height, data.thumbnail_width, data.thumbnail_height';
		
	public function getModule(&$options)
	{ 
	if ((!$addon = $this->getModelFromCache('XenForo_Model_AddOn')->getAddOnById('XfRuUserAlbums')) || empty($addon['active']))
		{
			return "killModule";
		}
	
	   $albums = $this->_getDb()->fetchAll('
			SELECT `image`.*, `user`.user_id, `user`.username, `album`.title AS albumTitle,
				' . self::$dataColumns . '
			FROM xfr_useralbum_image AS `image`
			INNER JOIN xfr_useralbum_image_data AS `data` ON
				(`data`.data_id = `image`.data_id)
			INNER JOIN xfr_useralbum AS `album` ON
				(`album`.album_id = `image`.album_id)
			INNER JOIN xf_user AS `user` ON
				(`user`.user_id = `album`.user_id)
			WHERE (`album`.album_type = "public" OR `album`.album_type = "global")AND moderation = 0
			ORDER BY `image`.image_date DESC
			LIMIT ?
		',$options['LatestAlbumPictures_limit']	
		
		);
		
		foreach ($albums as &$a)
		{
			
				$a['image'] = array(
				'thumbnailUrl' =>ltrim(self::THUMBS_PATH, '/') . floor($a['data_id'] / 1000). "/$a[data_id]-$a[file_hash].jpg",
				'albumTitle' => $a['albumTitle'],
				'username' => $a['username']

				);
			
		}
      

		return $albums;
	}
	
	

	

	

}
