<?php

class Brivium_ThreadsPostsOwner_Install
{
	public static function addColumn($table, $field, $attr)
	{
		if (!self::checkIfFieldExist($table, $field)) 
		{
			$db = XenForo_Application::get('db');
			return $db->query("ALTER TABLE `" . $table . "` ADD `" . $field . "` " . $attr);
		}
	}

	public static function checkIfFieldExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW COLUMNS FROM `' . $table . '` WHERE Field = ?', $field)) 
		{
			return true;
		}
		else 
		{
			return false;
		}
	}
	
	public static function checkIfTableExist($table)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW TABLES LIKE \'' . $table . '\'')) 
		{
			return true;
		}
		else 
		{
			return false;
		}
	}
	
	public static function installCode()
	{
		$db = XenForo_Application::get('db');
				
		$db->query("
			CREATE TABLE IF NOT EXISTS xf_thread_icon (
				icon_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT ,
				title VARCHAR(50) NOT NULL,
				image_url VARCHAR(250) NOT NULL,
				sprite_mode TINYINT(3) UNSIGNED NOT NULL DEFAULT 0,
				sprite_params TEXT NOT NULL,
				PRIMARY KEY (icon_id)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");
		if (!self::checkIfFieldExist('xf_post', 'icon_id')) 
		{
			self::addColumn('xf_thread', 'icon_id', "  SMALLINT(5) NULL  ");
		}
	}
	
	public static function uninstallCode()
	{
		$db = XenForo_Application::get('db');
		$db->query("
			DROP TABLE xf_thread_icon
		");
		$db->query("
			ALTER TABLE  `xf_thread` DROP  `icon_id`
		");
	}	
}