<?php
class Brivium_ThreadsPostsOwner_ControllerPublic_Post extends XFCP_Brivium_ThreadsPostsOwner_ControllerPublic_Post
{
	public function actionEdit()
	{
		$response = parent::actionEdit();

		if ($response instanceof XenForo_ControllerResponse_View)
		{
			$visitor = XenForo_Visitor::getInstance();
			$ownerModel = $this->_getOwnerModel();

			$datetime = $response->params['post']['post_date'];
			$datetime = new DateTime(date('r', $datetime));
			$datetime->setTimezone(new DateTimeZone($visitor['timezone']));
			$datetime = explode('.', $datetime->format('Y-m-d.h.i.A'));

			$datetime = array(
				'date' => $datetime[0],
				'hour' => $datetime[1],
				'mins' => $datetime[2],
				'meri' => $datetime[3]
			);

			switch ($datetime['hour'])
			{
				case "01":	$datetime['time']['01'] = 'selected="selected"'; break;
				case "02":	$datetime['time']['02'] = 'selected="selected"'; break;
				case "03":	$datetime['time']['03'] = 'selected="selected"'; break;
				case "04":	$datetime['time']['04'] = 'selected="selected"'; break;
				case "05":	$datetime['time']['05'] = 'selected="selected"'; break;
				case "06":	$datetime['time']['06'] = 'selected="selected"'; break;
				case "07":	$datetime['time']['07'] = 'selected="selected"'; break;
				case "08":	$datetime['time']['08'] = 'selected="selected"'; break;
				case "09":	$datetime['time']['09'] = 'selected="selected"'; break;
				case "10":	$datetime['time']['10'] = 'selected="selected"'; break;
				case "11":	$datetime['time']['11'] = 'selected="selected"'; break;
				default:	$datetime['time']['12'] = 'selected="selected"'; break;
			}

			switch ($datetime['meri'])
			{
				case "PM":	$datetime['ampm']['pm'] = 'selected="selected"'; break;
				default:	$datetime['ampm']['am'] = 'selected="selected"'; break;
			}

			$response->params += array(
				'canChangeOwner' => $ownerModel->canChangeOwner(),
				'datetime' => $datetime
			);
		}

		return $response;
	}

	public function actionSave()
	{
		$response = parent::actionSave();

		$this->_assertPostOnly();

		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
		$this->_assertCanEditPost($post, $thread, $forum);

		$postOwner = $this->_input->filterSingle('post_owner', XenForo_Input::UINT);
		$newPostOwner = $this->_input->filterSingle('new_post_owner', XenForo_Input::STRING);
		$input = $this->_input->filter(array(
			'date' => XenForo_Input::STRING,
			'hour' => XenForo_Input::UINT,
			'mins' => XenForo_Input::UINT,
			'ampm' => XenForo_Input::STRING
		));

		$db = XenForo_Application::getDb();
		$visitor = XenForo_Visitor::getInstance()->toArray();

		$userModel = $this->_getUserModel();
		$ownerModel = $this->_getOwnerModel();
		
		if($ownerModel->canChangeOwner())
		{

			$input['time'] = $input['hour'] . ":" . str_pad($input['mins'], 2, "0", STR_PAD_LEFT);

			$datetime = $input['date']." ".$input['time']." ".$input['ampm'];
			$timeOffset = $ownerModel->getTimeZoneOffset($visitor);

			$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
			$dw->setExistingData($postId);
			$dw->set('post_date', strtotime($datetime) - $timeOffset);
			$dw->save();

			$db->query('
	    		UPDATE xf_search_index
	    		SET item_date = ?
	    		WHERE content_id = ?
	    		AND content_type = ?
	    	', array((strtotime($datetime) - $timeOffset), $postId, 'post'));

			if ($postOwner) 
			{
				if (!$newPostOwner) 
		    	{
		    		return $this->responseError(new XenForo_Phrase('please_complete_required_fields'));
		    	}
		    	else 
		    	{
		    		$newOwner = $userModel->getUserByName($newPostOwner, array(
						'join' => XenForo_Model_User::FETCH_USER_FULL
					));
					if (!$newOwner)
					{
						return $this->responseError(new XenForo_Phrase('requested_user_not_found'));
					}
					if ($newOwner['user_id'] === $post['user_id'])
					{
						return $this->responseError(new XenForo_Phrase('you_already_own_this_post'));
					}
		    	}	    

		    	$user = $userModel->getUserById($post['user_id']);

		    	$threadDw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
		    	
		    	if($post['position'] === 0 && $thread['reply_count'] > 0)
		    	{
		    		$threadDw->setExistingData($thread);
		    		$threadDw->set('user_id', $newOwner['user_id']);
					$threadDw->set('username', $newOwner['username']);
					$threadDw->save();

					$db->query('
			    		UPDATE xf_search_index
			    		SET user_id = ?
			    		WHERE content_id = ?
			    		AND content_type = ?
			    	', array($newOwner['user_id'], $thread['thread_id'], 'thread'));
		    	}

		    	if($thread['reply_count'] === 0)
		    	{

					$threadDw->setExistingData($thread);
		    		$threadDw->set('user_id', $newOwner['user_id']);
					$threadDw->set('username', $newOwner['username']);
					$threadDw->set('last_post_user_id', $newOwner['user_id']);
					$threadDw->set('last_post_username', $newOwner['username']);
					$threadDw->save();

					$db->query('
			    		UPDATE xf_search_index
			    		SET user_id = ?
			    		WHERE content_id = ?
			    		AND content_type = ?
			    	', array($newOwner['user_id'], $thread['thread_id'], 'thread'));
		    	}

		    	if($post['position'] === $thread['reply_count'] && $thread['reply_count'] > 0)
		    	{
		    		$threadDw->setExistingData($thread);
		    		$threadDw->set('last_post_user_id', $newOwner['user_id']);
					$threadDw->set('last_post_username', $newOwner['username']);
					$threadDw->save();
		    	}

		    	$likes = unserialize($post['like_users']);
		    	
		    	$likeModel = $this->_getLikeModel();
			    $userLikes = $likeModel->getContentLikeByLikeUser('post', $post['post_id'], $newOwner['user_id']);

			    if ($userLikes)
				{
					$likeModel->unlikeContent($userLikes);
				}

			    $postData = array(
		    		'user_id' => $newOwner['user_id'],
		    		'username' => $newOwner['username'],
		    		'like_users' => serialize($likes)
		    	);

				$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
				$dw->setExistingData($postId);
				$dw->bulkSet($postData);
				$dw->save();

				$ownerData = array(
		    		'message_count' => $newOwner['message_count'] + 1
		    	);

				$ownerDw = XenForo_DataWriter::create('XenForo_DataWriter_User');
				$ownerDw->setExistingData($newOwner);

				$userData = array(
		    		'message_count' => $user['message_count'] - 1
		    	);

				$userDw = XenForo_DataWriter::create('XenForo_DataWriter_User');
		    	$userDw->setExistingData($user);

		    	if ($likes)
		    	{
		    		$ownerData += array(
		    			'like_count' => $newOwner['like_count'] + count($likes)
		    		);
		    		
		    		$userData += array(
		    			'like_count' => $user['like_count'] - count($likes)
		    		);
		    	}

		    	$ownerDw->bulkSet($ownerData);
		    	$ownerDw->save();
		    	
		    	$userDw->bulkSet($userData);
		    	$userDw->save();

				$db->query('
		    		UPDATE xf_search_index
		    		SET user_id = ?
		    		WHERE content_id = ?
		    		AND content_type = ?
		    	', array($newOwner['user_id'], $postId, 'post'));

			}
		}
		return $response;
	}

	protected function _getOwnerModel()
	{
		return $this->getModelFromCache('Brivium_ThreadsPostsOwner_Model_Owner');
	}

	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}

	protected function _getLikeModel()
	{
		return $this->getModelFromCache('XenForo_Model_Like');
	}
}