<?php

class Brivium_Credits_Model_Currency extends XenForo_Model
{
	public function getCurrencyById($id, $fetchMaster = false)
	{
		return $this->_getDb()->fetchRow('
				SELECT *
				FROM xf_credits_currency
				WHERE currency_id = ?
			', $id);
	}

	public function getAllCurrencies()
	{
		if (($currencies = $this->_getLocalCacheData('allCurrencies')) === false)
		{
			$currencies = $this->fetchAllKeyed('
				SELECT *
				FROM xf_credits_currency
				ORDER BY title
			', 'currency_id');

			$this->setLocalCacheData('allCurrencies', $currencies);
		}

		return $currencies;
	}
	public function getActiveCurrencies()
	{
		if (($currencies = $this->_getLocalCacheData('allCurrencies')) === false)
		{
			$currencies = $this->fetchAllKeyed('
				SELECT *
				FROM xf_credits_currency
				WHERE status = 1
				ORDER BY title
			', 'currency_id');

			$this->setLocalCacheData('allCurrencies', $currencies);
		}

		return $currencies;
	}
	/**
	* Helper to get the default currency
	*
	* @return array
	*/
	public function getDefaultCurrency()
	{
		return array(
			'currency_id' => 0,
			'title' => '',
			'code' => '',
			'symbol_left' => '',
			'symbol_right' => '',
			'decimal_place' => 0,
			'value' => 1.00000,
			'status' => 1,
		);
	}
	
	/**
	 * Returns an array of all currencies, suitable for use in ACP template syntax as options source.
	 *
	 * @param array $currencyTree
	 *
	 * @return array
	 */
	public function getCurrenciesForOptionsTag($selectedId = null, $allCurrencies= null)
	{
		if ($allCurrencies === null)
		{
			$allCurrencies = $this->getAllCurrencies();
		}

		$currencies = array();
		foreach ($allCurrencies AS $id => $currency)
		{
			$currencies[$id] = array(
				'value' => $id,
				'label' => $currency['title'],
				'selected' => ($selectedId == $id),
			);
		}

		return $currencies;
	}

	
	/**
	 * Gets all currencies in the format expected by the currency cache.
	 *
	 * @return array Format: [currency id] => info, with phrase cache as array
	 */
	public function getAllCurrenciesForCache()
	{
		$this->resetLocalCacheData('allCurrencies');

		$currencies = $this->getAllCurrencies();
		return $currencies;
	}

	/**
	 * Rebuilds the full currency cache.
	 *
	 * @return array Format: [currency id] => info, with phrase cache as array
	 */
	public function rebuildCurrencyCache()
	{
		$this->resetLocalCacheData('allCurrencies');

		$currencies = $this->getAllCurrenciesForCache();

		$this->_getDataRegistryModel()->set('brcCurrencies', $currencies);

		return $currencies;
	}
	
	/**
	 * Rebuilds all currency caches.
	 */
	public function rebuildCurrencyCaches()
	{
		$this->rebuildCurrencyCache();
	}

	
	
	
}