<?php

class Brivium_Credits_Model_Attachment extends XFCP_Brivium_Credits_Model_Attachment
{
	/**
	 * Logs the viewing of an attachment.
	 *
	 * @param integer $attachmentId
	 */
	public function logAttachmentView($attachmentId)
	{
		$attachment = $this->getAttachmentById($attachmentId);
		$user = XenForo_Visitor::getInstance()->toArray();
		$userId = $user['user_id'];
		if (!empty($attachment['data_id']) && ($userId ||(!$userId && XenForo_Application::get('options')->BRC_guestTriggerViewActions))){
			$attachmentData = $this->getAttachmentDataById($attachment['data_id']);
			if($attachmentData['user_id'] != $userId){
				$options = XenForo_Application::get('options');
				
				$extensionMap =	preg_split('/\s+/', trim($options->BRC_excludedFileExtensions));
				if(!$extensionMap)$extensionMap=array();
				$extension = XenForo_Helper_File::getFileExtension($attachment['filename']);
				if (!in_array($extension, $extensionMap))
				{
					$creditModel = $this->_getCreditModel();
					$errorString = '';
					if($userId){
						
						if($creditModel->countActionOfUser('downloadAttachment',$userId,0,$attachmentData['user_id'])){
							return parent::logAttachmentView($attachmentId);
						}
						$dataCredit = array(
							'user' 	=>	$user,
							'user_action_id' 	=>	$attachmentData['user_id'],
							'extra_data' =>	array(
								'attachment_id'	=> $attachmentId
							),
						);
						$creditModel->updateUserCredit('downloadAttachment',$userId,$dataCredit,$errorString);
					}
					if(!$errorString)
					{
						$dataCredit = array(
							'user_action_id' 	=>	XenForo_Visitor::getUserId(),
							'extra_data' =>	array(
								'attachment_id'	=> $attachmentId
							),
						);
						$creditModel->updateUserCredit('attachmentDownloaded',$attachmentData['user_id'],$dataCredit);
					}
				}
			}
		}
		return parent::logAttachmentView($attachmentId);
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
}