<?php

/**
 * Helper methods to generate currency sensitive output.
 *
 * @package Brivium_Credits
 */
class Brivium_Credits_Currency
{
	protected $_code = '';
	/**
	 * Default currency.
	 *
	 * @var array
	 */
	protected static $_currency = array();
	
	protected static $_currencies = array();
	
	/**
	 * The ID of the currency.
	 *
	 * @var integer
	 */
	protected static $_currencyId = 0;
	
	/**
	 * Private constructor. Use this class statically.
	 */
	private function __construct()
	{
	}
	
	/**
	 * Set list all currencies information.
	 *
	 * @param array $currencies
	 */
	public static function setCurrencies(array $currencies)
	{
		self::$_currencies = $currencies;
	}
	/**
	 * Set the default currency information.
	 *
	 * @param array $currency
	 */
	public static function setDefaultCurrency(array $currency)
	{
		self::$_currency = $currency;
	}
	
	/**
	 * Set the default currency information.
	 *
	 * @param array $currency
	 */
	public static function setDefaultCurrencyId($currencyId)
	{
		self::$_currencyId = $currencyId;
	}
	
	
	
	/**
	 * Formats the given number for a currency.
	 *
	 * @param float|integer $number Number to format
	 * @param array|null $currency Currency to override default
	 *
	 * @return string Formatted number
	 */
	public static function currencyFormat($number = 0,$negate=false, array $currency = null)
	{
		if (!$currency)
		{
			$currency = self::$_currency;
		}
		$negative = false;
		$formated = '';
		if (is_numeric($number)) {
			if ($number < 0)
			{
				$negative = true;
				$number *= -1;
			}
			$number *= $currency['value'];
			$number = XenForo_Locale::numberFormat($number,$currency['decimal_place']);
		}
		$formated = $negate && $negative?'- ':'';
		if (($currency['symbol_left'])) {
      		$formated .= $currency['symbol_left'];
    	}
		$formated .= $number;
		if (($currency['symbol_right'])) {
      		$formated .= $currency['symbol_right'];
    	}
		return $formated;
	}
	
	/**
	 * Convert the given number from currency to other.
	 *
	 * @param float|integer $value Number to convert
	 * @param integer $from currency_id
	 * @param integer $to currency_id
	 *
	 * @return float converted number
	 */
  	public static function convert($value, $from = 0, $to = 1) {
		if(!$from)$from = self::$_currencyId;
		if(!$to)$to = 1;
		if (isset(self::$_currencies[$from])) {
			$from = self::$_currencies[$from]['value'];
		} else {
			$from = self::$_currency['value'];
		}
		
		if (isset(self::$_currencies[$to])) {
			$to = self::$_currencies[$to]['value'];
		} else {
			$to = 1;
		}
		return $value * ($to / $from);
  	}
	
  	public static function getId($currencyId = 0) {
		if (!$currencyId) {
			return self::$_currency['currency_id'];
		} elseif ($currencyId && isset(self::$_currencies[$currencyId])) {
			return self::$_currencies[$currencyId]['currency_id'];
		} else {
			return 0;
		}
  	}
	
	public static function getSymbolLeft($currencyId = 0) {
		if (!$currencyId) {
			return self::$_currency['symbol_left'];
		} elseif ($currencyId && isset(self::$_currencies[$currencyId])) {
			return self::$_currencies[$currencyId]['symbol_left'];
		} else {
			return '';
		}
  	}
	
	public static function getSymbolRight($currencyId = 0) {
		if (!$currencyId) {
			return self::$_currency['symbol_right'];
		} elseif ($currencyId && isset(self::$_currencies[$currencyId])) {
			return self::$_currencies[$currencyId]['symbol_right'];
		} else {
			return '';
		}
  	}
	
	public static function getDecimalPlace($currencyId = 0) {
		if (!$currencyId) {
			return self::$_currency['decimal_place'];
		} elseif ($currencyId && isset(self::$_currencies[$currencyId])) {
			return self::$_currencies[$currencyId]['decimal_place'];
		} else {
			return 0;
		}
  	}
	
  	public static function getCode() {
    	return $this->code;
  	}
  
  	public static function getValue($currencyId = 0) {
		if (!$currencyId) {
			return self::$_currency['value'];
		} elseif ($currencyId && isset(self::$_currencies[$currencyId])) {
			return self::$_currencies[$currencyId]['value'];
		} else {
			return 0;
		}
  	}
    
  	public static function has($currencyId) {
    	return isset(self::$_currencies[$currencyId]);
  	}
	
	
}