<?php

/**
 * Controller for registration-related actions.
 *
 * @package XenForo_Users
 */
class Brivium_Credits_ControllerPublic_Register extends XFCP_Brivium_Credits_ControllerPublic_Register
{
	
	/**
	 * Registers a new user.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionRegister()
	{
		$response = parent::actionRegister();
		if($userId = XenForo_Visitor::getUserId()){
			$creditModel = $this->_getCreditModel();
			$creditModel->updateUserCredit('registration',$userId);
		}
		return $response;
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
}