<?php

abstract class Waindigo_Listener_TemplatePostRender extends Waindigo_Listener_Template
{
	protected $_templateName = null;
	protected $_containerData = null;

	public function __construct($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template) {
		$this->_templateName = $templateName;
		$this->_containerData = $containerData;
		parent::__construct($content, $template);
	}
	
	public function run() {
		switch ($this->_templateName)
		{
			case 'PAGE_CONTAINER':
				if (!self::$_copyrightNotice) $this->_copyrightNotice();
				break;
		}
		return array($this->_contents, $this->_containerData);
	}
	
	// This only works on PHP 5.3+, so method should be overridden for now
	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		$class = get_called_class();
		$templatePostRender = new $class($templateName, $content, $containerData, $template);
		list($content, $containerData) = $templatePostRender->run();
	}
	
	protected function _copyrightNotice()
	{
		if (!isset(XenForo_Application::getInstance()->adminStyleModifiedDate))
		{
			$newContents = preg_replace('#(<div class="breadBoxBottom">\s*<nav>.*</nav>\s*</div>)#Us', '$1'.self::$copyrightNotice, $this->_contents);
			if ($newContents != $this->_contents)
			{
				$this->_contents = $newContents;
			}
			else
			{
				$this->_contents = preg_replace('#(<body.*>.*)</body>#Us', '$1'.self::$copyrightNotice.'</body>', $this->_contents);
			}
		}
		self::$_copyrightNotice = true;
	}
}