<?php

abstract class Waindigo_Listener_TemplateCreate
{
	protected $_templateName = null;
	protected $_params = null;
	/**
	 * @var XenForo_Template_Abstract
	 */	
	protected $_template = null;
	
	public function run()
	{
		return array($this->_templateName, $this->_params);
	} /* END Waindigo_Listener_TemplateCreate::run */
			
	/**
	 * @param string $templateName
	 * @param array $params
	 * @param XenForo_Template_Abstract $template
	 */
	public function __construct(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		$this->_templateName = $templateName;
		$this->_params = $params;
		$this->_template = $template;
	} /* END Waindigo_Listener_TemplateCreate::__construct */

	/**
	 * Called whenever the template object constructor is called. You may use this event to modify the name of the template being called, to modify the params being passed to the template, or to pre-load additional templates as needed.
	 * 
	 * @param string $templateName - the name of the template to be rendered
	 * @param array $params - key-value pairs of parameters that are available to the template
	 * @param XenForo_Template_Abstract $template - the template object itself
	 */
	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
	    // This only works on PHP 5.3+, so method should be overridden for now
	    $class = get_called_class();
	    $templateCreate = new $class($templateName, $params, $template);
	    list($templateName, $params) = $templateCreate->run();
	} /* END Waindigo_Listener_TemplateCreate::templateCreate */
	
	/**
	 * @param string $templateName
	 */
	protected function _preloadTemplate($templateName)
	{
		$this->_template->preloadTemplate($templateName);
	} /* END Waindigo_Listener_TemplateCreate::_preloadTemplate */
			
	/**
	 * @param array $templateNames
	 */
	protected function _preloadTemplates(array $templateNames)
	{
		foreach ($templateNames as $templateName) {
			$this->_preloadTemplate($templateName);
		}
	} /* END Waindigo_Listener_TemplateCreate::_preloadTemplates */

	/**
	 * Use account_personal_details, account_privacy
	 */
	protected final function _accountPrivacyDob()
	{
	} /* END Waindigo_Listener_TemplateCreate::_accountPrivacyDob */
	
	/**
	 * Use post_permalink
	 */
	protected final function _addthisAjax()
	{
	} /* END Waindigo_Listener_TemplateCreate::_addthisAjax */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _adAboveContent()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adAboveContent */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _adAboveTopBreadcrumb()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adAboveTopBreadcrumb */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _adBelowBottomBreadcrumb()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adBelowBottomBreadcrumb */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _adBelowContent()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adBelowContent */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _adBelowTopBreadcrumb()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adBelowTopBreadcrumb */
	
	/**
	 * Use forum_view
	 */
	protected final function _adForumViewAboveNodeList()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adForumViewAboveNodeList */
	
	/**
	 * Use forum_view
	 */
	protected final function _adForumViewAboveThreadList()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adForumViewAboveThreadList */
	
	/**
	 * Use header, logo_block, PAGE_CONTAINER
	 */
	protected final function _adHeader()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adHeader */
	
	/**
	 * Use member_view
	 */
	protected final function _adMemberViewAboveMessages()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adMemberViewAboveMessages */
	
	/**
	 * Use member_view
	 */
	protected final function _adMemberViewBelowAvatar()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adMemberViewBelowAvatar */
	
	/**
	 * Use member_view
	 */
	protected final function _adMemberViewSidebarBottom()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adMemberViewSidebarBottom */
	
	/**
	 * Use conversation_message, conversation_view,
	 * conversation_view_new_messages, message, post, post_deleted,
	 * post_moderated, thread_reply_new_posts, thread_view
	 */
	protected final function _adMessageBelow()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adMessageBelow */
	
	/**
	 * Use conversation_message, conversation_view,
	 * conversation_view_new_messages, message, post, post_deleted,
	 * post_moderated, thread_reply_new_posts, thread_view
	 */
	protected final function _adMessageBody()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adMessageBody */
	
	/**
	 * Use PAGE_CONTAINER, sidebar_visitor_panel
	 */
	protected final function _adSidebarBelowVisitorPanel()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adSidebarBelowVisitorPanel */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _adSidebarBottom()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adSidebarBottom */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _adSidebarTop()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adSidebarTop */
	
	/**
	 * Use forum_view, thread_list
	 */
	protected final function _adThreadListBelowStickies()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adThreadListBelowStickies */
	
	/**
	 * Use thread_view
	 */
	protected final function _adThreadViewAboveMessages()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adThreadViewAboveMessages */
	
	/**
	 * Use thread_view
	 */
	protected final function _adThreadViewBelowMessages()
	{
	} /* END Waindigo_Listener_TemplateCreate::_adThreadViewBelowMessages */
	
	/**
	 * Use account_alerts_popup
	 */
	protected final function _alert()
	{
	} /* END Waindigo_Listener_TemplateCreate::_alert */
	
	/**
	 * Use conversation_message, conversation_view,
	 * conversation_view_new_messages, post, post_deleted, post_moderated,
	 * thread_reply_new_posts, thread_view
	 */
	protected final function _attachedFiles()
	{
	} /* END Waindigo_Listener_TemplateCreate::_attachedFiles */
	
	/**
	 * Use conversation_add, conversation_message_edit, conversation_reply,
	 * conversation_view, post_edit, quick_reply, thread_create, thread_reply,
	 * thread_view
	 */
	protected final function _attachmentEditor()
	{
	} /* END Waindigo_Listener_TemplateCreate::_attachmentEditor */
	
	/**
	 * Use attachment_editor, conversation_add, conversation_message_edit,
	 * conversation_reply, conversation_view, post_edit, quick_reply,
	 * thread_create, thread_reply, thread_view
	 */
	protected final function _attachmentEditorAttachment()
	{
	} /* END Waindigo_Listener_TemplateCreate::_attachmentEditorAttachment */
	
	/**
	 * Use attachment_editor, conversation_add, conversation_message_edit,
	 * conversation_reply, conversation_view, post_edit, quick_reply,
	 * thread_create, thread_reply, thread_view
	 */
	protected final function _attachmentUploadButton()
	{
	} /* END Waindigo_Listener_TemplateCreate::_attachmentUploadButton */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _breadcrumb()
	{
	} /* END Waindigo_Listener_TemplateCreate::_breadcrumb */
	
	/**
	 * Use online_user_ip, post_ip, profile_post_ip
	 */
	protected final function _contentIp()
	{
	} /* END Waindigo_Listener_TemplateCreate::_contentIp */
	
	/**
	 * Use conversation_list
	 */
	protected final function _conversationListItem()
	{
	} /* END Waindigo_Listener_TemplateCreate::_conversationListItem */
	
	/**
	 * Use conversation_list_popup
	 */
	protected final function _conversationListPopupItem()
	{
	} /* END Waindigo_Listener_TemplateCreate::_conversationListPopupItem */
	
	/**
	 * Use conversation_view, conversation_view_new_messages
	 */
	protected final function _conversationMessage()
	{
	} /* END Waindigo_Listener_TemplateCreate::_conversationMessage */
	
	/**
	 * Use conversation_view
	 */
	protected final function _conversationRecipients()
	{
	} /* END Waindigo_Listener_TemplateCreate::_conversationRecipients */
	
	/**
	 * Use account_contact_details, account_personal_details,
	 * account_preferences, register_facebook, register_form
	 */
	protected final function _customFieldsEdit()
	{
	} /* END Waindigo_Listener_TemplateCreate::_customFieldsEdit */
	
	/**
	 * Use account_contact_details, account_personal_details,
	 * account_preferences, custom_fields_edit, register_facebook, register_form
	 */
	protected final function _customFieldEdit()
	{
	} /* END Waindigo_Listener_TemplateCreate::_customFieldEdit */
	
	/**
	 * Use member_view
	 */
	protected final function _customFieldView()
	{
	} /* END Waindigo_Listener_TemplateCreate::_customFieldView */
	
	/**
	 * Use editor
	 */
	protected final function _editorJsSetup()
	{
	} /* END Waindigo_Listener_TemplateCreate::_editorJsSetup */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _footer()
	{
	} /* END Waindigo_Listener_TemplateCreate::_footer */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _googleAnalytics()
	{
	} /* END Waindigo_Listener_TemplateCreate::_googleAnalytics */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _header()
	{
	} /* END Waindigo_Listener_TemplateCreate::_header */
	
	/**
	 * Use account_personal_details, register_form
	 */
	protected final function _helperBirthdayInput()
	{
	} /* END Waindigo_Listener_TemplateCreate::_helperBirthdayInput */
	
	/**
	 * Use contact, lost_password, register_form, thread_create, thread_reply
	 */
	protected final function _helperCaptchaUnit()
	{
	} /* END Waindigo_Listener_TemplateCreate::_helperCaptchaUnit */
	
	/**
	 * Use inline_mod_post_delete, inline_mod_profile_post_delete,
	 * inline_mod_thread_delete, post_delete, profile_post_delete, thread_delete
	 */
	protected final function _helperDeletionTypeUnit()
	{
	} /* END Waindigo_Listener_TemplateCreate::_helperDeletionTypeUnit */
	
	/**
	 * Use error_with_login, login
	 */
	protected final function _helperLoginForm()
	{
	} /* END Waindigo_Listener_TemplateCreate::_helperLoginForm */
	
	/**
	 * Use post_edit, thread_create, thread_reply
	 */
	protected final function _helperThreadWatchInput()
	{
	} /* END Waindigo_Listener_TemplateCreate::_helperThreadWatchInput */
	
	/**
	 * Use help_bb_codes
	 */
	protected final function _helpBbCodesExample()
	{
	} /* END Waindigo_Listener_TemplateCreate::_helpBbCodesExample */
	
	/**
	 * Use find_new_threads, forum_view, inline_mod_controls_thread,
	 * member_view, thread_list, thread_view
	 */
	protected final function _inlineModControls()
	{
	} /* END Waindigo_Listener_TemplateCreate::_inlineModControls */
	
	/**
	 * Use find_new_threads, forum_view, thread_list
	 */
	protected final function _inlineModControlsThread()
	{
	} /* END Waindigo_Listener_TemplateCreate::_inlineModControlsThread */
	
	/**
	 * Use inline_mod_thread_merge, inline_mod_thread_move, thread_fields_move,
	 * thread_move
	 */
	protected final function _inlineModThreadHelperRedirect()
	{
	} /* END Waindigo_Listener_TemplateCreate::_inlineModThreadHelperRedirect */
	
	/**
	 * Use conversation_message, conversation_view,
	 * conversation_view_new_messages, member_view, message, post,
	 * post_deleted, post_moderated, profile_post, thread_reply_new_posts,
	 * thread_view
	 */
	protected final function _likesSummary()
	{
	} /* END Waindigo_Listener_TemplateCreate::_likesSummary */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _loginBar()
	{
	} /* END Waindigo_Listener_TemplateCreate::_loginBar */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _loginBarForm()
	{
	} /* END Waindigo_Listener_TemplateCreate::_loginBarForm */
	
	/**
	 * Use header, PAGE_CONTAINER
	 */
	protected final function _logoBlock()
	{
	} /* END Waindigo_Listener_TemplateCreate::_logoBlock */
	
	/**
	 * Use account_following, account_ignored, member_followers,
	 * member_following, member_list, member_list_item_follower,
	 * member_list_item_ignored, online_list, post_likes, profile_post_likes
	 */
	protected final function _memberListItem()
	{
	} /* END Waindigo_Listener_TemplateCreate::_memberListItem */
	
	/**
	 * Use account_following
	 */
	protected final function _memberListItemFollower()
	{
	} /* END Waindigo_Listener_TemplateCreate::_memberListItemFollower */
	
	/**
	 * Use account_ignored
	 */
	protected final function _memberListItemIgnored()
	{
	} /* END Waindigo_Listener_TemplateCreate::_memberListItemIgnored */
	
	/**
	 * Use conversation_message, conversation_view,
	 * conversation_view_new_messages, post, post_deleted, post_moderated,
	 * thread_reply_new_posts, thread_view
	 */
	protected final function _message()
	{
	} /* END Waindigo_Listener_TemplateCreate::_message */
	
	/**
	 * Use post_deleted_placeholder, thread_view
	 */
	protected final function _messageDeletedPlaceholder()
	{
	} /* END Waindigo_Listener_TemplateCreate::_messageDeletedPlaceholder */
	
	/**
	 * Use member_view, profile_post
	 */
	protected final function _messageSimple()
	{
	} /* END Waindigo_Listener_TemplateCreate::_messageSimple */
	
	/**
	 * Use member_view, profile_post_deleted
	 */
	protected final function _messageSimpleDeletedPlaceholder()
	{
	} /* END Waindigo_Listener_TemplateCreate::_messageSimpleDeletedPlaceholder */
	
	/**
	 * Use conversation_message, conversation_view,
	 * conversation_view_new_messages, message, post, post_deleted,
	 * post_moderated, quick_reply, thread_reply_new_posts, thread_view
	 */
	protected final function _messageUserInfo()
	{
	} /* END Waindigo_Listener_TemplateCreate::_messageUserInfo */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _moderatorBar()
	{
	} /* END Waindigo_Listener_TemplateCreate::_moderatorBar */
	
	/**
	 * Use header, PAGE_CONTAINER
	 */
	protected final function _navigation()
	{
	} /* END Waindigo_Listener_TemplateCreate::_navigation */
	
	/**
	 * Use header, navigation, PAGE_CONTAINER
	 */
	protected final function _navigationVisitorTab()
	{
	} /* END Waindigo_Listener_TemplateCreate::_navigationVisitorTab */
	
	/**
	 * Use member_recent_activity, news_feed_page, news_feed_page_global
	 */
	protected final function _newsFeed()
	{
	} /* END Waindigo_Listener_TemplateCreate::_newsFeed */
	
	/**
	 * Use news_feed_item_post_insert, news_feed_item_post_like,
	 * news_feed_item_thread_insert
	 */
	protected final function _newsFeedAttachedImages()
	{
	} /* END Waindigo_Listener_TemplateCreate::_newsFeedAttachedImages */
	
	/**
	 * Use member_recent_activity, news_feed_page, news_feed_page_global
	 */
	protected final function _newsFeedEnd()
	{
	} /* END Waindigo_Listener_TemplateCreate::_newsFeedEnd */
	
	/**
	 * Use account_likes, member_recent_activity, news_feed, news_feed_page,
	 * news_feed_page_global
	 */
	protected final function _newsFeedItem()
	{
	} /* END Waindigo_Listener_TemplateCreate::_newsFeedItem */
	
	/**
	 * Use node_forum_level_1
	 */
	protected final function _nodeForumLevel2()
	{
	} /* END Waindigo_Listener_TemplateCreate::_nodeForumLevel2 */
	
	/**
	 * Use node_link_level_1
	 */
	protected final function _nodeLinkLevel2()
	{
	} /* END Waindigo_Listener_TemplateCreate::_nodeLinkLevel2 */
	
	/**
	 * Use forum_list, forum_view
	 */
	protected final function _nodeList()
	{
	} /* END Waindigo_Listener_TemplateCreate::_nodeList */
	
	/**
	 * Use node_page_level_1
	 */
	protected final function _nodePageLevel2()
	{
	} /* END Waindigo_Listener_TemplateCreate::_nodePageLevel2 */
	
	/**
	 * Use notices, PAGE_CONTAINER
	 */
	protected final function _notice()
	{
	} /* END Waindigo_Listener_TemplateCreate::_notice */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _notices()
	{
	} /* END Waindigo_Listener_TemplateCreate::_notices */
	
	/**
	 * Use forum_list, member_view, pagenode_container, thread_view
	 */
	protected final function _openGraphMeta()
	{
	} /* END Waindigo_Listener_TemplateCreate::_openGraphMeta */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _pageContainerJsBody()
	{
	} /* END Waindigo_Listener_TemplateCreate::_pageContainerJsBody */
	
	/**
	 * Use editor_dialog_code, editor_dialog_color_picker, editor_dialog_image,
	 * editor_dialog_link, editor_dialog_media, PAGE_CONTAINER
	 */
	protected final function _pageContainerJsHead()
	{
	} /* END Waindigo_Listener_TemplateCreate::_pageContainerJsHead */
	
	/**
	 * Use thread_poll_results, thread_view
	 */
	protected final function _pollBlock()
	{
	} /* END Waindigo_Listener_TemplateCreate::_pollBlock */
	
	/**
	 * Use thread_poll_results, thread_view
	 */
	protected final function _pollBlockResult()
	{
	} /* END Waindigo_Listener_TemplateCreate::_pollBlockResult */
	
	/**
	 * Use thread_view
	 */
	protected final function _pollBlockVote()
	{
	} /* END Waindigo_Listener_TemplateCreate::_pollBlockVote */
	
	/**
	 * Use post_deleted, post_moderated, thread_reply_new_posts, thread_view
	 */
	protected final function _post()
	{
	} /* END Waindigo_Listener_TemplateCreate::_post */
	
	/**
	 * Use thread_view
	 */
	protected final function _postDeletedPlaceholder()
	{
	} /* END Waindigo_Listener_TemplateCreate::_postDeletedPlaceholder */
	
	/**
	 * Use conversation_message_edit_preview
	 */
	protected final function _postEditPreview()
	{
	} /* END Waindigo_Listener_TemplateCreate::_postEditPreview */
	
	/**
	 * Use find_new_threads, forum_view, news_feed_page, news_feed_page_global,
	 * online_list, thread_list, watch_threads, watch_threads_all
	 */
	protected final function _previewTooltip()
	{
	} /* END Waindigo_Listener_TemplateCreate::_previewTooltip */
	
	/**
	 * Use member_view
	 */
	protected final function _profilePost()
	{
	} /* END Waindigo_Listener_TemplateCreate::_profilePost */
	
	/**
	 * Use member_view, profile_post, profile_post_comments
	 */
	protected final function _profilePostComment()
	{
	} /* END Waindigo_Listener_TemplateCreate::_profilePostComment */
	
	/**
	 * Use profile_post_comments
	 */
	protected final function _profilePostCommentsBefore()
	{
	} /* END Waindigo_Listener_TemplateCreate::_profilePostCommentsBefore */
	
	/**
	 * Use member_view
	 */
	protected final function _profilePostDeleted()
	{
	} /* END Waindigo_Listener_TemplateCreate::_profilePostDeleted */
	
	/**
	 * Use conversation_view, thread_view
	 */
	protected final function _quickReply()
	{
	} /* END Waindigo_Listener_TemplateCreate::_quickReply */
	
	/**
	 * Use report_list, report_list_closed
	 */
	protected final function _reportListItem()
	{
	} /* END Waindigo_Listener_TemplateCreate::_reportListItem */
	
	/**
	 * Use header, PAGE_CONTAINER
	 */
	protected final function _searchBar()
	{
	} /* END Waindigo_Listener_TemplateCreate::_searchBar */
	
	/**
	 * Use forum_view, post_delete, post_edit, post_edit_inline, post_ip,
	 * post_like, post_likes, post_report, thread_create, thread_delete,
	 * thread_edit, thread_move, thread_poll_edit, thread_poll_results,
	 * thread_poll_voters, thread_reply, thread_view, thread_watch
	 */
	protected final function _searchBarForumOnly()
	{
	} /* END Waindigo_Listener_TemplateCreate::_searchBarForumOnly */
	
	/**
	 * Use post_delete, post_edit, post_edit_inline, post_ip, post_like,
	 * post_likes, post_report, thread_delete, thread_edit, thread_move,
	 * thread_poll_edit, thread_poll_results, thread_poll_voters, thread_reply,
	 * thread_view, thread_watch
	 */
	protected final function _searchBarThreadOnly()
	{
	} /* END Waindigo_Listener_TemplateCreate::_searchBarThreadOnly */
	
	/**
	 * Use search_form, search_form_post, search_form_profile_post
	 */
	protected final function _searchFormTabs()
	{
	} /* END Waindigo_Listener_TemplateCreate::_searchFormTabs */
	
	/**
	 * Use pagenode_container, thread_view
	 */
	protected final function _sharePage()
	{
	} /* END Waindigo_Listener_TemplateCreate::_sharePage */
	
	/**
	 * Use forum_list, news_feed_page_global
	 */
	protected final function _sidebarOnlineUsers()
	{
	} /* END Waindigo_Listener_TemplateCreate::_sidebarOnlineUsers */
	
	/**
	 * Use forum_list, member_view
	 */
	protected final function _sidebarSharePage()
	{
	} /* END Waindigo_Listener_TemplateCreate::_sidebarSharePage */
	
	/**
	 * Use PAGE_CONTAINER
	 */
	protected final function _sidebarVisitorPanel()
	{
	} /* END Waindigo_Listener_TemplateCreate::_sidebarVisitorPanel */
	
	/**
	 * Use inline_mod_thread_move, thread_move
	 */
	protected final function _threadFieldsMove()
	{
	} /* END Waindigo_Listener_TemplateCreate::_threadFieldsMove */
	
	/**
	 * Use thread_create, thread_edit, thread_reply
	 */
	protected final function _threadFieldsStatus()
	{
	} /* END Waindigo_Listener_TemplateCreate::_threadFieldsStatus */
	
	/**
	 * Use forum_view
	 */
	protected final function _threadList()
	{
	} /* END Waindigo_Listener_TemplateCreate::_threadList */
	
	/**
	 * Use find_new_threads, forum_view, thread_list, watch_threads,
	 * watch_threads_all
	 */
	protected final function _threadListItem()
	{
	} /* END Waindigo_Listener_TemplateCreate::_threadListItem */
	
	/**
	 * Use find_new_threads, forum_view, thread_list, thread_list_item,
	 * watch_threads, watch_threads_all
	 */
	protected final function _threadListItemDeleted()
	{
	} /* END Waindigo_Listener_TemplateCreate::_threadListItemDeleted */
	
	/**
	 * Use inline_mod_post_move, thread_create, thread_edit, thread_move
	 */
	protected final function _titlePrefixEdit()
	{
	} /* END Waindigo_Listener_TemplateCreate::_titlePrefixEdit */
	
	/**
	 * Use inline_mod_post_move, inline_mod_thread_move, thread_create,
	 * thread_edit, thread_fields_move, thread_list_item_edit, thread_move,
	 * title_prefix_edit
	 */
	protected final function _titlePrefixEditOptions()
	{
	} /* END Waindigo_Listener_TemplateCreate::_titlePrefixEditOptions */
	
	/**
	 * Use help_trophies, member_trophies
	 */
	protected final function _trophy()
	{
	} /* END Waindigo_Listener_TemplateCreate::_trophy */
}