<?php

class Waindigo_LastPostAvatar_Listener_TemplatePostRender extends Waindigo_Listener_TemplatePostRender
{
	public function run()
	{
		switch ($this->_templateName) {
			case 'node_forum_level_1':
			case 'node_forum_level_2':
			case 'node_category_level_2':
			case 'waindigo_node_level_1_socialgroups':
			case 'waindigo_node_level_2_socialgroups':
			case 'waindigo_library_level_1_library':
			case 'waindigo_library_level_2_library':
			case 'waindigo_social_forum_list_item_socialgroups':
				$this->_nodeForumLevel2();
				break;
		}
		return parent::run();
	} /* END Waindigo_LastPostAvatar_Listener_TemplatePostRender::run */

	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		$templatePostRender = new Waindigo_LastPostAvatar_Listener_TemplatePostRender($templateName, $content, $containerData, $template);
		list($content, $containerData) = $templatePostRender->run();
	} /* Waindigo_LastPostAvatar_Listener_TemplatePostRender::templatePostRender */

	protected function _nodeForumLevel2()
	{
		$viewParams = $this->_fetchViewParams();
		$lastPostTitleMaxChars = XenForo_Application::get('options')->waindigo_lastPostAvatar_lastPostTitleMaxLength;
		if (isset($viewParams['forum'])) {
			$node = $viewParams['forum'];
			if (!$node['lastPost']['date']) {
			    return;
			}
			$rendered = $this->_render('waindigo_node_forum_avatar_lastpostavatar');
			$title = XenForo_Helper_String::wholeWordTrim($node['lastPost']['title'], $lastPostTitleMaxChars);
		} else if (isset($viewParams['category'])) {
			$node = $viewParams['category'];
			if (!$node['lastPost']['date']) {
			    return;
			}
			$rendered = $this->_render('waindigo_node_category_avatar_lastpostavatar');
			$title = XenForo_Helper_String::wholeWordTrim($node['lastPost']['title'], $lastPostTitleMaxChars);
		} else if (isset($viewParams['library'])) {
			$node = $viewParams['library'];
			if (!$node['lastArticlePage']['date']) {
			    return;
			}
			$rendered = $this->_render('waindigo_node_library_avatar_lastpostavatar');
			$title = XenForo_Helper_String::wholeWordTrim($node['lastArticlePage']['title'], $lastPostTitleMaxChars);
		}
		if (!isset($node['privateInfo']) || !$node['privateInfo']) {
    		$pattern = '#(<div class="nodeLastPost(?: secondaryContent)?">)(.*)(\s*<a[^>]*>)[^<]*(</a>\s*<span class="lastThreadMeta">.*</span>\s*</div>)#Us';
    		$replacement = '${1}' . $rendered . '${2}' . '${3}' . $title . '${4}';
    		$this->_contents = preg_replace($pattern, $replacement, $this->_contents, 1);
		}
	} /* END Waindigo_LastPostAvatar_Listener_TemplatePostRender::_nodeForumLevel2 */
}