<?php
/**
 * @package PowerDigital_Unanswered_Model
 * @author Luqman Amjad http://luqmanamjad.com
 */
class PowerDigital_Unanswered_Model extends XFCP_PowerDigital_Unanswered_Model {
  
  public function getUnansweredThreads(array $conditions, array &$fetchOptions){
    
    $whereConditions = $this->prepareUnansweredThreadConditions($conditions, $fetchOptions);
    
    $sqlClauses = $this->prepareThreadFetchOptions($fetchOptions);
    $limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
    
    return $this->fetchAllKeyed($this->limitQueryResults(
      '
        SELECT thread.*
          ' . $sqlClauses['selectFields'] . '
        FROM xf_thread AS thread
        ' . $sqlClauses['joinTables'] . '
        WHERE ' . $whereConditions . '
        ' . $sqlClauses['orderClause'] . '
      ', $limitOptions['limit'], $limitOptions['offset']
    ), 'thread_id');
  }
  
  /**
   * Prepares a collection of thread fetching related conditions into an SQL clause
   *
   * @param array $conditions List of conditions
   * @param array $fetchOptions Modifiable set of fetch options (may have joins pushed on to it)
   *
   * @return string SQL clause (at least 1=1)
   */
  public function prepareUnansweredThreadConditions(array $conditions, array &$fetchOptions)
  {
    $sqlConditions = array();
    $db = $this->_getDb();
    $options = XenForo_Application::get('options');
    
    if (!empty($conditions['forum_id']))
    {
      $forumIds = explode(',', $conditions['forum_id']);
      if (!empty($forumIds))
      {
        //this will stop ->prepareThreadConditions() from creating its own condition
        unset($conditions['forum_id']);
        $sqlConditions[] = 'thread.node_id IN (' . $db->quote($forumIds) . ')';
      }
    }
    
    //This next three could be included in some 
    $forumIdsToExclude = $options->unansweredForumsToExclude;
    if (!empty($forumIdsToExclude))
    {
      $forumIdsToExclude = explode(',', $forumIdsToExclude);
      
      if (!empty($forumIdsToExclude))
      {
        $sqlConditions[] = 'thread.node_id NOT IN (' . $db->quote($forumIdsToExclude) . ')';
      }
    }
    
    $unansweredThreadsToExclude = $options->unansweredThreadsToExclude;
    if (!empty($unansweredThreadsToExclude))
    {
      $unansweredThreadsToExclude = explode(',', $unansweredThreadsToExclude);
      
      if (!empty($unansweredThreadsToExclude))
      {
        $sqlConditions[] = 'thread.thread_id NOT IN (' . $db->quote($unansweredThreadsToExclude) . ')';
      }
    }
    
    $unansweredUsersToExclude = $options->unansweredUsersToExclude;
    if (!empty($unansweredUsersToExclude))
    {
      $unansweredUsersToExclude = explode(',', $unansweredUsersToExclude);
      
      if (!empty($unansweredUsersToExclude))
      {
        $sqlConditions[] = 'thread.user_id NOT IN (' . $db->quote($unansweredUsersToExclude) . ')';
      }
    }
    
    if (!$options->unansweredIncludeStickyThreads)
    {  
      $conditions['sticky'] = 0;
    }
    
    $sqlConditions[] = 'reply_count = 0';
    
    return $this->getConditionsForClause($sqlConditions) . ' AND ' .  $this->prepareThreadConditions($conditions, $fetchOptions);
  }
  
}